/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.externalstorage;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.storage.AbstractStorageContainerMenu;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;

public class ExternalStorageContainerMenu
extends AbstractStorageContainerMenu {
    private static final int FILTER_SLOT_X = 8;
    private static final int FILTER_SLOT_Y = 20;
    private final Predicate<Player> stillValid;

    public ExternalStorageContainerMenu(int syncId, Inventory playerInventory, ResourceContainerData resourceContainerData) {
        super(Menus.INSTANCE.getExternalStorage(), syncId);
        this.addSlots(playerInventory.player, ResourceContainerImpl.createForFilter(resourceContainerData));
        this.stillValid = p -> true;
    }

    ExternalStorageContainerMenu(int syncId, Player player, ResourceContainer resourceContainer, StorageConfigurationContainer configContainer, Predicate<Player> stillValid) {
        super(Menus.INSTANCE.getExternalStorage(), syncId, player, configContainer);
        this.addSlots(player, resourceContainer);
        this.stillValid = stillValid;
    }

    private void addSlots(Player player, ResourceContainer resourceContainer) {
        for (int i = 0; i < resourceContainer.size(); ++i) {
            this.addSlot(this.createFilterSlot(resourceContainer, i));
        }
        this.addPlayerInventory(player.getInventory(), 8, 55);
        this.transferManager.addFilterTransfer((Container)player.getInventory());
    }

    private Slot createFilterSlot(ResourceContainer resourceContainer, int i) {
        int x = 8 + 18 * i;
        return new ResourceSlot(resourceContainer, i, (Component)IdentifierUtil.createTranslation("gui", "storage.filter_help"), x, 20, ResourceSlotType.FILTER);
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }
}

