/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.externalstorage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.tracked.InMemoryTrackedStorageRepository;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;

class ExternalStorageTrackedStorageRepository
extends InMemoryTrackedStorageRepository {
    private static final Codec<ChangedByAt> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceCodecs.CODEC.fieldOf("resource").forGetter(ChangedByAt::resource), (App)Codec.STRING.fieldOf("changedBy").forGetter(ChangedByAt::changedBy), (App)Codec.LONG.fieldOf("changedAt").forGetter(ChangedByAt::changedAt)).apply((Applicative)instance, ChangedByAt::new));
    private static final Codec<List<ChangedByAt>> LIST_CODEC = Codec.list(CODEC);
    private final Runnable listener;

    ExternalStorageTrackedStorageRepository(Runnable listener) {
        this.listener = listener;
    }

    @Override
    public void update(ResourceKey resource, Actor actor, long time) {
        super.update(resource, actor, time);
        this.listener.run();
    }

    Tag toTag(HolderLookup.Provider provider) {
        return (Tag)LIST_CODEC.encode(this.getTrackedResources(), (DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)new ListTag()).getOrThrow();
    }

    private List<ChangedByAt> getTrackedResources() {
        return this.trackedResourcesByActorType.getOrDefault(PlayerActor.class, Collections.emptyMap()).entrySet().stream().filter(entry -> entry.getKey() instanceof PlatformResourceKey).map(entry -> new ChangedByAt((PlatformResourceKey)entry.getKey(), ((TrackedResource)entry.getValue()).getSourceName(), ((TrackedResource)entry.getValue()).getTime())).toList();
    }

    void fromTag(Tag tag, HolderLookup.Provider provider) {
        LIST_CODEC.decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).ifSuccess(result -> ((List)result.getFirst()).forEach(changedByAt -> super.update(changedByAt.resource(), new PlayerActor(changedByAt.changedBy()), changedByAt.changedAt())));
    }

    private record ChangedByAt(PlatformResourceKey resource, String changedBy, long changedAt) {
    }
}

