/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeMapping;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.amount.ResourceAmountScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.MouseClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallTextClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeItemClientTooltipComponent;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apiguardian.api.API;

public abstract class AbstractBaseScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected static final int TITLE_MAX_WIDTH = 162;
    private static final SmallTextClientTooltipComponent CLICK_TO_CLEAR = new SmallTextClientTooltipComponent((Component)IdentifierUtil.createTranslationAsHeading("gui", "filter_slot.click_to_clear"));
    private static final SmallTextClientTooltipComponent SHIFT_CLICK_TO_CLEAR = new SmallTextClientTooltipComponent((Component)IdentifierUtil.createTranslationAsHeading("gui", "filter_slot.shift_click_to_clear"));
    private static final ClientTooltipComponent EMPTY_FILTER = ClientTooltipComponent.create((FormattedCharSequence)IdentifierUtil.createTranslationAsHeading("gui", "filter_slot.empty_filter").getVisualOrderText());
    private static final ClientTooltipComponent EMPTY_UPGRADE_SLOT = ClientTooltipComponent.create((FormattedCharSequence)IdentifierUtil.createTranslationAsHeading("gui", "empty_upgrade_slot").getVisualOrderText());
    protected final TextMarquee titleMarquee;
    private final Inventory playerInventory;
    private final List<Rect2i> exclusionZones = new ArrayList<Rect2i>();
    private int sideButtonY;
    @Nullable
    private List<ClientTooltipComponent> deferredTooltip;

    protected AbstractBaseScreen(T menu, Inventory playerInventory, Component title) {
        this(menu, playerInventory, new TextMarquee(title, 162));
    }

    protected AbstractBaseScreen(T menu, Inventory playerInventory, TextMarquee title) {
        super(menu, playerInventory, title.getText());
        this.playerInventory = playerInventory;
        this.titleLabelX = 7;
        this.titleLabelY = 7;
        this.inventoryLabelX = 7;
        this.titleMarquee = title;
    }

    protected int getSideButtonY() {
        return 6;
    }

    protected int getSideButtonX() {
        return this.leftPos - 18 - 2;
    }

    protected void init() {
        this.clearWidgets();
        super.init();
        this.sideButtonY = this.getSideButtonY();
    }

    protected void clearWidgets() {
        super.clearWidgets();
        this.exclusionZones.clear();
    }

    protected abstract ResourceLocation getTexture();

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(this.getTexture(), x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderResourceSlots(graphics);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.pose().popPose();
        int n = this.titleMarquee.getEffectiveWidth(this.font);
        Objects.requireNonNull(this.font);
        boolean hoveringOverTitle = this.isHovering(this.titleLabelX, this.titleLabelY, n, 9, mouseX, mouseY);
        this.titleMarquee.render(graphics, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY, this.font, hoveringOverTitle);
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        this.renderPlayerInventoryTitle(graphics);
    }

    protected final void renderPlayerInventoryTitle(GuiGraphics graphics) {
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderResourceSlots(GuiGraphics graphics) {
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (!(abstractContainerMenu instanceof AbstractResourceContainerMenu)) {
            return;
        }
        AbstractResourceContainerMenu resourceContainerMenu = (AbstractResourceContainerMenu)abstractContainerMenu;
        for (ResourceSlot slot : resourceContainerMenu.getResourceSlots()) {
            ResourceSlotRendering.render(graphics, slot, this.leftPos, this.topPos);
        }
    }

    public void addSideButton(AbstractSideButtonWidget button) {
        button.setX(this.getSideButtonX());
        button.setY(this.topPos + this.sideButtonY);
        this.exclusionZones.add(new Rect2i(button.getX(), button.getY(), button.getWidth(), button.getHeight()));
        this.sideButtonY += button.getHeight() + 2;
        this.addRenderableWidget((GuiEventListener)button);
    }

    @API(status=API.Status.INTERNAL)
    public List<Rect2i> getExclusionZones() {
        return this.exclusionZones;
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        ResourceSlot resourceSlot;
        Object tooltip;
        Slot slot = this.hoveredSlot;
        if (slot instanceof UpgradeSlot) {
            UpgradeSlot upgradeSlot = (UpgradeSlot)slot;
            tooltip = this.getUpgradeTooltip(this.menu.getCarried(), upgradeSlot);
            if (!tooltip.isEmpty()) {
                Platform.INSTANCE.renderTooltip(graphics, (List<ClientTooltipComponent>)tooltip, x, y);
                return;
            }
        }
        if ((tooltip = this.hoveredSlot) instanceof ResourceSlot && this.canInteractWithResourceSlot(resourceSlot = (ResourceSlot)((Object)tooltip), x, y) && !(tooltip = this.getResourceSlotTooltip(this.menu.getCarried(), resourceSlot)).isEmpty()) {
            Platform.INSTANCE.renderTooltip(graphics, (List<ClientTooltipComponent>)tooltip, x, y);
            return;
        }
        if (this.deferredTooltip != null) {
            Platform.INSTANCE.renderTooltip(graphics, this.deferredTooltip, x, y);
            this.deferredTooltip = null;
        }
        super.renderTooltip(graphics, x, y);
    }

    public void setDeferredTooltip(@Nullable List<ClientTooltipComponent> deferredTooltip) {
        this.deferredTooltip = deferredTooltip;
    }

    private List<ClientTooltipComponent> getUpgradeTooltip(ItemStack carried, UpgradeSlot upgradeSlot) {
        if (!carried.isEmpty() || upgradeSlot.hasItem()) {
            return Collections.emptyList();
        }
        ArrayList<ClientTooltipComponent> lines = new ArrayList<ClientTooltipComponent>();
        lines.add(EMPTY_UPGRADE_SLOT);
        for (UpgradeMapping upgrade : upgradeSlot.getAllowedUpgrades()) {
            lines.add(new UpgradeItemClientTooltipComponent(upgrade));
        }
        return lines;
    }

    public final List<ClientTooltipComponent> getResourceSlotTooltip(ItemStack carried, ResourceSlot slot) {
        PlatformResourceKey resource = slot.getResource();
        if (resource == null) {
            return this.getTooltipForEmptyResourceSlot(carried, slot);
        }
        return this.getResourceSlotTooltip(resource, slot);
    }

    protected List<ClientTooltipComponent> getResourceSlotTooltip(ResourceKey resource, ResourceSlot slot) {
        List<ClientTooltipComponent> tooltip = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass()).getTooltip(resource).stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).collect(Collectors.toList());
        if (!slot.isDisabled() && !slot.supportsItemSlotInteractions()) {
            this.addResourceSlotTooltips(slot, tooltip);
        }
        if (slot.supportsItemSlotInteractions()) {
            RefinedStorageApi.INSTANCE.getResourceContainerInsertStrategies().stream().flatMap(strategy -> strategy.getConversionInfo(resource, this.getMenu().getCarried()).stream()).map(conversionInfo -> MouseClientTooltipComponent.itemConversion(MouseClientTooltipComponent.Type.LEFT, conversionInfo.from(), conversionInfo.to(), null)).forEach(tooltip::add);
        }
        return tooltip;
    }

    private List<ClientTooltipComponent> getTooltipForEmptyResourceSlot(ItemStack carried, ResourceSlot slot) {
        if (slot.isDisabled() || slot.supportsItemSlotInteractions()) {
            return Collections.emptyList();
        }
        ArrayList<ClientTooltipComponent> tooltip = new ArrayList<ClientTooltipComponent>();
        tooltip.add(EMPTY_FILTER);
        tooltip.addAll(this.getResourceSlotHelpTooltip(carried, slot));
        tooltip.add(HelpClientTooltipComponent.create(slot.getHelpText()));
        return tooltip;
    }

    private List<ClientTooltipComponent> getResourceSlotHelpTooltip(ItemStack carried, ResourceSlot resourceSlot) {
        if (carried.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClientTooltipComponent> lines = new ArrayList<ClientTooltipComponent>();
        resourceSlot.getPrimaryResourceFactory().create(carried).ifPresent(primaryResourceInstance -> lines.add(MouseClientTooltipComponent.resource(MouseClientTooltipComponent.Type.LEFT, primaryResourceInstance.resource(), null)));
        for (ResourceFactory alternativeResourceFactory : resourceSlot.getAlternativeResourceFactories()) {
            Optional<ResourceAmount> result = alternativeResourceFactory.create(carried);
            result.ifPresent(alternativeResourceInstance -> lines.add(MouseClientTooltipComponent.resource(MouseClientTooltipComponent.Type.RIGHT, alternativeResourceInstance.resource(), null)));
        }
        return lines;
    }

    protected void addResourceSlotTooltips(ResourceSlot slot, List<ClientTooltipComponent> tooltip) {
        if (slot.canModifyAmount()) {
            tooltip.add(new SmallTextClientTooltipComponent(slot.getClickToConfigureAmountHelpTooltip()));
            tooltip.add(SHIFT_CLICK_TO_CLEAR);
        } else {
            tooltip.add(CLICK_TO_CLEAR);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        ResourceSlot resourceSlot;
        Slot slot = this.hoveredSlot;
        if (slot instanceof ResourceSlot && !(resourceSlot = (ResourceSlot)slot).supportsItemSlotInteractions() && !resourceSlot.isDisabled() && this.canInteractWithResourceSlot(resourceSlot, mouseX, mouseY)) {
            AbstractContainerMenu abstractContainerMenu;
            if (!this.tryOpenResourceAmountScreen(resourceSlot) && (abstractContainerMenu = this.getMenu()) instanceof AbstractResourceContainerMenu) {
                AbstractResourceContainerMenu resourceMenu = (AbstractResourceContainerMenu)abstractContainerMenu;
                resourceMenu.sendResourceSlotChange(this.hoveredSlot.index, clickedButton == 1);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    private boolean tryOpenResourceAmountScreen(ResourceSlot slot) {
        boolean canOpen;
        boolean isFilterSlot = slot.getResource() != null;
        boolean canModifyAmount = isFilterSlot && slot.canModifyAmount();
        boolean isNotTryingToRemoveFilter = !AbstractBaseScreen.hasShiftDown();
        boolean isNotCarryingItem = this.getMenu().getCarried().isEmpty();
        boolean bl = canOpen = isFilterSlot && canModifyAmount && isNotTryingToRemoveFilter && isNotCarryingItem;
        if (canOpen && this.minecraft != null) {
            this.minecraft.setScreen(this.createResourceAmountScreen(slot));
        }
        return canOpen;
    }

    protected Screen createResourceAmountScreen(ResourceSlot slot) {
        return new ResourceAmountScreen((Screen)this, this.playerInventory, slot);
    }

    protected boolean canInteractWithResourceSlot(ResourceSlot resourceSlot, double mouseX, double mouseY) {
        return true;
    }

    @Nullable
    @API(status=API.Status.INTERNAL)
    public PlatformResourceKey getHoveredResource() {
        Slot slot = this.hoveredSlot;
        if (slot instanceof ResourceSlot) {
            ResourceSlot resourceSlot = (ResourceSlot)slot;
            return resourceSlot.getResource();
        }
        return null;
    }

    @API(status=API.Status.INTERNAL)
    public int getLeftPos() {
        return this.leftPos;
    }

    @API(status=API.Status.INTERNAL)
    public int getTopPos() {
        return this.topPos;
    }
}

