/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.support.CraftingMatrixContainerMenu;
import com.refinedmods.refinedstorage.common.support.network.ResourceSorters;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;

public class RecipeMatrixContainer
extends TransientCraftingContainer {
    @Nullable
    private final Runnable listener;
    private boolean muted;

    public RecipeMatrixContainer(@Nullable Runnable listener, int width, int height) {
        super((AbstractContainerMenu)new CraftingMatrixContainerMenu(listener), width, height);
        this.listener = listener;
    }

    public void changed() {
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public boolean clearToPlayerInventory(Player player) {
        boolean clearedAll = true;
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack matrixStack = this.getItem(i);
            if (matrixStack.isEmpty()) continue;
            if (player.getInventory().add(matrixStack)) {
                this.setItem(i, ItemStack.EMPTY);
                continue;
            }
            clearedAll = false;
        }
        return clearedAll;
    }

    public boolean clearIntoStorage(RootStorage rootStorage, Player player) {
        boolean clearedAll = true;
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack matrixStack = this.getItem(i);
            if (matrixStack.isEmpty()) continue;
            ItemStack remainder = this.doInsert(matrixStack, player, rootStorage);
            if (!remainder.isEmpty()) {
                clearedAll = false;
            }
            this.setItem(i, remainder);
        }
        return clearedAll;
    }

    private ItemStack doInsert(ItemStack stack, Player player, RootStorage rootStorage) {
        long inserted = rootStorage.insert(ItemResource.ofItemStack(stack), stack.getCount(), Action.EXECUTE, new PlayerActor(player));
        long remainder = (long)stack.getCount() - inserted;
        if (remainder == 0L) {
            return ItemStack.EMPTY;
        }
        return stack.copyWithCount((int)remainder);
    }

    public void transferRecipe(Player player, @Nullable RootStorage rootStorage, List<List<ItemResource>> recipe) {
        boolean cleared;
        boolean bl = cleared = rootStorage == null ? this.clearToPlayerInventory(player) : this.clearIntoStorage(rootStorage, player);
        if (!cleared) {
            return;
        }
        Comparator<ResourceKey> sorter = ResourceSorters.create(rootStorage, player.getInventory());
        for (int i = 0; i < this.getContainerSize() && i < recipe.size(); ++i) {
            List<ItemResource> possibilities = recipe.get(i);
            possibilities.sort(sorter);
            this.doTransferRecipe(i, possibilities, player, rootStorage);
        }
    }

    private void doTransferRecipe(int index, List<ItemResource> sortedPossibilities, Player player, @Nullable RootStorage rootStorage) {
        for (ItemResource possibility : sortedPossibilities) {
            boolean extracted;
            boolean bl = extracted = rootStorage != null && rootStorage.extract(possibility, 1L, Action.EXECUTE, new PlayerActor(player)) == 1L;
            if (!extracted) {
                extracted = this.extractSingleItemFromPlayerInventory(player, possibility);
            }
            if (!extracted) continue;
            this.setItem(index, possibility.toItemStack());
            return;
        }
    }

    private boolean extractSingleItemFromPlayerInventory(Player player, ItemResource possibility) {
        ItemStack possibilityStack = possibility.toItemStack();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack playerStack = player.getInventory().getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)playerStack, (ItemStack)possibilityStack)) continue;
            player.getInventory().removeItem(i, 1);
            return true;
        }
        return false;
    }

    public void updateMatrixAndNotifyListenerLater(Runnable callback) {
        this.muted = true;
        try {
            callback.run();
        }
        finally {
            this.muted = false;
            this.changed();
        }
    }

    public boolean isMuted() {
        return this.muted;
    }
}

