/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.energy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.AbstractListeningEnergyStorage;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ItemBlockEnergyStorage
extends AbstractListeningEnergyStorage {
    private static final String TAG_STORED = "stored";
    private final ItemStack stack;
    private final BlockEntityType<?> blockEntityType;

    public ItemBlockEnergyStorage(EnergyStorage energyStorage, ItemStack stack, BlockEntityType<?> blockEntityType) {
        super(energyStorage);
        this.stack = stack;
        this.blockEntityType = blockEntityType;
        CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null) {
            ItemBlockEnergyStorage.readFromTag(energyStorage, customData.copyTag());
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    protected void onStoredChanged(long stored) {
        CustomData customData = (CustomData)this.stack.get(DataComponents.BLOCK_ENTITY_DATA);
        CompoundTag tag = customData == null ? new CompoundTag() : customData.copyTag();
        ItemBlockEnergyStorage.writeToTag(tag, stored);
        BlockItem.setBlockEntityData((ItemStack)this.stack, this.blockEntityType, (CompoundTag)tag);
    }

    public static void writeToTag(CompoundTag tag, long stored) {
        tag.putLong(TAG_STORED, stored);
    }

    public static void readFromTag(EnergyStorage energyStorage, CompoundTag tag) {
        long stored = tag.getLong(TAG_STORED);
        energyStorage.receive(stored, Action.EXECUTE);
    }
}

