/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.s2c;

import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.storage.StorageCodecs;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record GridUpdatePacket(PlatformResourceKey resource, long amount, Optional<TrackedResource> trackedResource) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GridUpdatePacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier("grid_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GridUpdatePacket> STREAM_CODEC = StreamCodec.composite(ResourceCodecs.STREAM_CODEC, GridUpdatePacket::resource, (StreamCodec)ByteBufCodecs.VAR_LONG, GridUpdatePacket::amount, StorageCodecs.TRACKED_RESOURCE_OPTIONAL_STREAM_CODEC, GridUpdatePacket::trackedResource, GridUpdatePacket::new);

    public static void handle(GridUpdatePacket packet, PacketContext ctx) {
        AbstractContainerMenu abstractContainerMenu = ctx.getPlayer().containerMenu;
        if (abstractContainerMenu instanceof AbstractGridContainerMenu) {
            AbstractGridContainerMenu containerMenu = (AbstractGridContainerMenu)abstractContainerMenu;
            containerMenu.onResourceUpdate(packet.resource, packet.amount, packet.trackedResource.orElse(null));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }
}

