/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.s2c;

import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.storage.StorageInfo;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterData;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocrafterLockedUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocrafterManagerActivePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocrafterNameUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingMonitorActivePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingMonitorTaskAddedPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingMonitorTaskRemovedPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingMonitorTaskStatusChangedPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingPreviewCancelResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingPreviewMaxAmountResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingPreviewResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingTreePreviewResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.EnergyInfoPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.ExportingIndicatorUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.GridActivePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.GridClearPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.GridUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.MessagePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.NetworkTransmitterStatusPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.PatternGridAllowedAlternativesUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.ResourceSlotUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.StorageInfoResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.WirelessTransmitterDataPacket;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public final class S2CPackets {
    private S2CPackets() {
    }

    public static void sendEnergyInfo(ServerPlayer player, long stored, long capacity) {
        Platform.INSTANCE.sendPacketToClient(player, new EnergyInfoPacket(stored, capacity));
    }

    public static void sendWirelessTransmitterData(ServerPlayer player, int range, boolean active) {
        Platform.INSTANCE.sendPacketToClient(player, new WirelessTransmitterDataPacket(range, active));
    }

    public static void sendGridActive(ServerPlayer player, boolean active) {
        Platform.INSTANCE.sendPacketToClient(player, new GridActivePacket(active));
    }

    public static void sendAutocrafterManagerActive(ServerPlayer player, boolean active) {
        Platform.INSTANCE.sendPacketToClient(player, new AutocrafterManagerActivePacket(active));
    }

    public static void sendGridUpdate(ServerPlayer player, PlatformResourceKey resource, long change, @Nullable TrackedResource trackedResource) {
        Platform.INSTANCE.sendPacketToClient(player, new GridUpdatePacket(resource, change, Optional.ofNullable(trackedResource)));
    }

    public static void sendGridClear(ServerPlayer player) {
        Platform.INSTANCE.sendPacketToClient(player, GridClearPacket.INSTANCE);
    }

    public static void sendResourceSlotUpdate(ServerPlayer player, @Nullable ResourceAmount resourceAmount, int slotIndex) {
        Platform.INSTANCE.sendPacketToClient(player, new ResourceSlotUpdatePacket(slotIndex, Optional.ofNullable(resourceAmount)));
    }

    public static void sendStorageInfoResponse(ServerPlayer player, UUID id, StorageInfo storageInfo) {
        Platform.INSTANCE.sendPacketToClient(player, new StorageInfoResponsePacket(id, storageInfo.stored(), storageInfo.capacity()));
    }

    public static void sendNetworkTransmitterStatus(ServerPlayer player, NetworkTransmitterData status) {
        Platform.INSTANCE.sendPacketToClient(player, new NetworkTransmitterStatusPacket(status.error(), status.transmitting(), status.message()));
    }

    public static void sendMessage(ServerPlayer player, Component title, Component message) {
        Platform.INSTANCE.sendPacketToClient(player, new MessagePacket(title, message));
    }

    public static void sendPatternGridAllowedAlternativesUpdate(ServerPlayer player, int index, Set<ResourceLocation> ids) {
        Platform.INSTANCE.sendPacketToClient(player, new PatternGridAllowedAlternativesUpdatePacket(index, ids));
    }

    public static void sendAutocrafterNameUpdate(ServerPlayer player, Component name) {
        Platform.INSTANCE.sendPacketToClient(player, new AutocrafterNameUpdatePacket(name));
    }

    public static void sendAutocrafterLockedUpdate(ServerPlayer player, boolean locked) {
        Platform.INSTANCE.sendPacketToClient(player, new AutocrafterLockedUpdatePacket(locked));
    }

    public static void sendAutocraftingPreviewResponse(ServerPlayer player, UUID id, Preview preview) {
        Platform.INSTANCE.sendPacketToClient(player, new AutocraftingPreviewResponsePacket(id, preview));
    }

    public static void sendAutocraftingTreePreviewResponse(ServerPlayer player, UUID id, TreePreview preview) {
        Platform.INSTANCE.sendPacketToClient(player, new AutocraftingTreePreviewResponsePacket(id, preview));
    }

    public static void sendAutocraftingPreviewCancelResponse(ServerPlayer player) {
        Platform.INSTANCE.sendPacketToClient(player, AutocraftingPreviewCancelResponsePacket.INSTANCE);
    }

    public static void sendAutocraftingPreviewMaxAmountResponse(ServerPlayer player, long maxAmount) {
        Platform.INSTANCE.sendPacketToClient(player, new AutocraftingPreviewMaxAmountResponsePacket(maxAmount));
    }

    public static void sendAutocraftingResponse(ServerPlayer player, UUID id, boolean success) {
        Platform.INSTANCE.sendPacketToClient(player, new AutocraftingResponsePacket(id, success));
    }

    public static void sendAutocraftingMonitorTaskAdded(ServerPlayer player, TaskStatus taskStatus) {
        Platform.INSTANCE.sendPacketToClient(player, new AutocraftingMonitorTaskAddedPacket(taskStatus));
    }

    public static void sendAutocraftingMonitorTaskRemoved(ServerPlayer player, TaskId taskId) {
        Platform.INSTANCE.sendPacketToClient(player, new AutocraftingMonitorTaskRemovedPacket(taskId));
    }

    public static void sendAutocraftingMonitorTaskStatusChanged(ServerPlayer player, TaskStatus taskStatus) {
        Platform.INSTANCE.sendPacketToClient(player, new AutocraftingMonitorTaskStatusChangedPacket(taskStatus));
    }

    public static void sendAutocraftingMonitorActive(ServerPlayer player, boolean active) {
        Platform.INSTANCE.sendPacketToClient(player, new AutocraftingMonitorActivePacket(active));
    }

    public static void sendExportingIndicatorUpdate(ServerPlayer player, List<ExportingIndicatorUpdatePacket.UpdatedIndicator> indicators) {
        Platform.INSTANCE.sendPacketToClient(player, new ExportingIndicatorUpdatePacket(indicators));
    }
}

