/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource;

import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.FuzzyModeNormalizer;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.material.Fluid;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public record FluidResource(Fluid fluid, DataComponentPatch components) implements PlatformResourceKey,
FuzzyModeNormalizer
{
    public FluidResource(Fluid fluid) {
        this(fluid, DataComponentPatch.EMPTY);
    }

    public FluidResource(Fluid fluid, DataComponentPatch components) {
        this.fluid = CoreValidations.validateNotNull(fluid, "Fluid must not be null");
        this.components = CoreValidations.validateNotNull(components, "Components must not be null");
    }

    @Override
    public ResourceKey normalize() {
        return new FluidResource(this.fluid);
    }

    @Override
    public long getInterfaceExportLimit() {
        return ResourceTypes.FLUID.getInterfaceExportLimit();
    }

    @Override
    public long getProcessingPatternLimit() {
        return Platform.INSTANCE.getBucketAmount() * 16L;
    }

    @Override
    public List<ResourceTag> getTags() {
        return BuiltInRegistries.FLUID.wrapAsHolder((Object)this.fluid).tags().flatMap(tagKey -> BuiltInRegistries.FLUID.getTag(tagKey).stream()).map(tag -> new ResourceTag(tag.key(), tag.stream().map(holder -> new FluidResource((Fluid)holder.value())).toList())).toList();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceTypes.FLUID;
    }
}

