/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import io.netty.handler.codec.DecoderException;
import java.util.Optional;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public final class ResourceCodecs {
    public static final MapCodec<ItemResource> ITEM_MAP_CODEC = RecordCodecBuilder.mapCodec(ins -> ins.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(ItemResource::item), (App)DataComponentPatch.CODEC.fieldOf("components").forGetter(ItemResource::components)).apply((Applicative)ins, ItemResource::new));
    public static final Codec<ItemResource> ITEM_CODEC = ITEM_MAP_CODEC.codec();
    public static final MapCodec<FluidResource> FLUID_MAP_CODEC = RecordCodecBuilder.mapCodec(ins -> ins.group((App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("fluid").forGetter(FluidResource::fluid), (App)DataComponentPatch.CODEC.fieldOf("components").forGetter(FluidResource::components)).apply((Applicative)ins, FluidResource::new));
    public static final Codec<FluidResource> FLUID_CODEC = FLUID_MAP_CODEC.codec();
    public static final Codec<PlatformResourceKey> CODEC = RefinedStorageApi.INSTANCE.getResourceTypeRegistry().codec().dispatch(PlatformResourceKey::getResourceType, ResourceType::getMapCodec);
    public static final Codec<ResourceAmount> AMOUNT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CODEC.fieldOf("resource").forGetter(resourceAmount -> (PlatformResourceKey)resourceAmount.resource()), (App)Codec.LONG.fieldOf("amount").forGetter(ResourceAmount::amount)).apply((Applicative)instance, ResourceAmount::new));
    public static final Codec<Optional<ResourceAmount>> AMOUNT_OPTIONAL_CODEC = AMOUNT_CODEC.optionalFieldOf("resource").codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, PlatformResourceKey> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, PlatformResourceKey>(){

        public PlatformResourceKey decode(RegistryFriendlyByteBuf buf) {
            ResourceLocation id = buf.readResourceLocation();
            ResourceType resourceType = RefinedStorageApi.INSTANCE.getResourceTypeRegistry().get(id).orElseThrow();
            return (PlatformResourceKey)resourceType.getStreamCodec().decode((Object)buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, PlatformResourceKey resourceKey) {
            ResourceType resourceType = resourceKey.getResourceType();
            ResourceLocation id = RefinedStorageApi.INSTANCE.getResourceTypeRegistry().getId(resourceType).orElseThrow();
            buf.writeResourceLocation(id);
            resourceType.getStreamCodec().encode((Object)buf, (Object)resourceKey);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourceAmount> AMOUNT_STREAM_CODEC = StreamCodec.of((buf, resourceAmount) -> {
        ResourceKey resourceKey = resourceAmount.resource();
        if (!(resourceKey instanceof PlatformResourceKey)) {
            throw new DecoderException("Cannot encode non-platform resource key");
        }
        PlatformResourceKey platformResourceKey = (PlatformResourceKey)resourceKey;
        STREAM_CODEC.encode(buf, (Object)platformResourceKey);
        buf.writeLong(resourceAmount.amount());
    }, buf -> {
        PlatformResourceKey resourceKey = (PlatformResourceKey)STREAM_CODEC.decode(buf);
        long amount = buf.readLong();
        return new ResourceAmount(resourceKey, amount);
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<ResourceAmount>> AMOUNT_STREAM_OPTIONAL_CODEC = ByteBufCodecs.optional(AMOUNT_STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemResource> ITEM_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((net.minecraft.resources.ResourceKey)Registries.ITEM), ItemResource::item, (StreamCodec)DataComponentPatch.STREAM_CODEC, ItemResource::components, ItemResource::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidResource> FLUID_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((net.minecraft.resources.ResourceKey)Registries.FLUID), FluidResource::fluid, (StreamCodec)DataComponentPatch.STREAM_CODEC, FluidResource::components, FluidResource::new);

    private ResourceCodecs() {
    }
}

