/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.stretching;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSize;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSizeListener;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSizeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public abstract class AbstractStretchingScreen<T extends AbstractBaseContainerMenu>
extends AbstractBaseScreen<T> {
    protected static final int ROW_SIZE = 18;
    protected static final int TOP_HEIGHT = 19;
    private static final int INVENTORY_INCLUDING_TITLE_HEIGHT = 99;
    private static final int COLUMNS = 9;
    private static final int MIN_ROWS = 3;
    private static final int ROW_PADDING = 3;
    private int visibleRows;
    @Nullable
    private ScrollbarWidget scrollbar;

    protected AbstractStretchingScreen(T menu, Inventory playerInventory, TextMarquee title) {
        super(menu, playerInventory, title);
    }

    protected AbstractStretchingScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    @Override
    protected void init() {
        this.visibleRows = this.calculateVisibleRows();
        this.imageHeight = 19 + 18 * this.visibleRows + this.getBottomHeight();
        this.inventoryLabelY = this.imageHeight - 99 + 4;
        this.resize();
        super.init();
        this.scrollbar = new ScrollbarWidget(this.leftPos + 174, this.topPos + 20, ScrollbarWidget.Type.NORMAL, this.visibleRows * 18 - 2);
        this.scrollbar.setListener(offset -> this.scrollbarChanged(this.visibleRows));
        this.addWidget((GuiEventListener)this.scrollbar);
        this.init(this.visibleRows);
        this.addSideButton(new ScreenSizeSideButtonWidget(this));
    }

    protected void init(int rows) {
    }

    protected final void resize() {
        ((ScreenSizeListener)((Object)((AbstractBaseContainerMenu)this.getMenu()))).resized(this.imageHeight - 99 + 17, 20, 20 + 18 * this.visibleRows - 2);
    }

    protected final int getScrollbarOffset() {
        if (this.scrollbar == null) {
            return 0;
        }
        int scrollbarOffset = (int)this.scrollbar.getOffset();
        if (!this.scrollbar.isSmoothScrolling()) {
            return scrollbarOffset * 18;
        }
        return scrollbarOffset;
    }

    protected void scrollbarChanged(int rows) {
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(graphics, x, y);
        this.renderRows(graphics, mouseX, mouseY, x, y);
    }

    private void renderBackground(GuiGraphics graphics, int x, int y) {
        graphics.blit(this.getTexture(), x, y, 0, 0, this.imageWidth, 19);
        this.renderStretchingBackground(graphics, x, y + 19, this.visibleRows);
        graphics.blit(this.getTexture(), x, y + 19 + 18 * this.visibleRows, 0, this.getBottomV(), this.imageWidth, this.getBottomHeight());
    }

    private void renderRows(GuiGraphics graphics, int mouseX, int mouseY, int x, int y) {
        graphics.enableScissor(x + 7, y + 19 + 1, x + 7 + 162, y + 19 + 1 + 18 * this.visibleRows - 2);
        this.renderRows(graphics, x, y, 19, this.visibleRows, mouseX, mouseY);
        graphics.disableScissor();
    }

    protected abstract void renderRows(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract void renderStretchingBackground(GuiGraphics var1, int var2, int var3, int var4);

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollbar != null) {
            this.scrollbar.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        if (this.scrollbar != null && this.scrollbar.mouseClicked(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    public void mouseMoved(double mx, double my) {
        if (this.scrollbar != null) {
            this.scrollbar.mouseMoved(mx, my);
        }
        super.mouseMoved(mx, my);
    }

    public boolean mouseReleased(double mx, double my, int button) {
        return this.scrollbar != null && this.scrollbar.mouseReleased(mx, my, button) || super.mouseReleased(mx, my, button);
    }

    public boolean mouseScrolled(double x, double y, double z, double delta) {
        boolean didScrollbar = this.scrollbar != null && !AbstractStretchingScreen.hasShiftDown() && !AbstractStretchingScreen.hasControlDown() && this.scrollbar.mouseScrolled(x, y, z, delta);
        return didScrollbar || super.mouseScrolled(x, y, z, delta);
    }

    private int calculateVisibleRows() {
        int screenSpaceAvailable = this.height - 19 - this.getBottomHeight();
        int maxRows = this.getMaxRows();
        return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, maxRows));
    }

    protected final boolean isInStretchedArea(int y) {
        return y >= 19 && y < 19 + 18 * this.visibleRows;
    }

    private int getMaxRows() {
        return switch (Platform.INSTANCE.getConfig().getScreenSize()) {
            default -> throw new MatchException(null, null);
            case ScreenSize.STRETCH -> Platform.INSTANCE.getConfig().getMaxRowsStretch();
            case ScreenSize.SMALL -> 3;
            case ScreenSize.MEDIUM -> 5;
            case ScreenSize.LARGE -> 8;
            case ScreenSize.EXTRA_LARGE -> 12;
        };
    }

    protected final void updateScrollbar(int totalRows) {
        if (this.scrollbar == null) {
            return;
        }
        this.scrollbar.setEnabled(totalRows > this.visibleRows);
        int rowsExcludingVisibleOnes = totalRows - this.visibleRows;
        int maxOffset = this.scrollbar.isSmoothScrolling() ? rowsExcludingVisibleOnes * 18 + this.getScrollPanePadding() : rowsExcludingVisibleOnes;
        this.scrollbar.setMaxOffset(maxOffset);
    }

    protected abstract int getBottomHeight();

    protected abstract int getBottomV();

    protected int getScrollPanePadding() {
        return 0;
    }
}

