/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.autocrafting.PlatformPatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.neoforge.storage.CapabilityCache;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ItemHandlerExternalPatternProviderSink
implements PlatformPatternProviderExternalPatternSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemHandlerExternalPatternProviderSink.class);
    private final CapabilityCache capabilityCache;

    ItemHandlerExternalPatternProviderSink(CapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    @Override
    public ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action) {
        return this.capabilityCache.getItemHandler().map(handler -> this.accept(resources, action, (IItemHandler)handler)).orElse(ExternalPatternSink.Result.SKIPPED);
    }

    private ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action, IItemHandler handler) {
        boolean success;
        ArrayDeque<ItemStack> stacks = ItemHandlerExternalPatternProviderSink.getStacks(resources);
        ItemStack current = (ItemStack)stacks.poll();
        List<Integer> availableSlots = IntStream.range(0, handler.getSlots()).boxed().collect(Collectors.toList());
        while (current != null && !availableSlots.isEmpty()) {
            ItemStack remainder = this.insert(action, handler, availableSlots, current);
            if (remainder.isEmpty()) {
                current = (ItemStack)stacks.poll();
                continue;
            }
            if (current.getCount() == remainder.getCount()) break;
            current = remainder;
        }
        boolean bl = success = current == null && stacks.isEmpty();
        if (!success && action == Action.EXECUTE) {
            LOGGER.warn("{} unexpectedly left {} as a remainder, which has been voided", (Object)handler, stacks);
        }
        return success ? ExternalPatternSink.Result.ACCEPTED : ExternalPatternSink.Result.REJECTED;
    }

    private ItemStack insert(Action action, IItemHandler handler, List<Integer> availableSlots, ItemStack current) {
        ItemStack remainder = ItemStack.EMPTY;
        for (int i = 0; i < availableSlots.size(); ++i) {
            int slot = availableSlots.get(i);
            remainder = handler.insertItem(slot, current.copy(), action == Action.SIMULATE);
            if (!remainder.isEmpty() && current.getCount() == remainder.getCount()) continue;
            availableSlots.remove(i);
            break;
        }
        return remainder;
    }

    private static ArrayDeque<ItemStack> getStacks(Collection<ResourceAmount> resources) {
        return new ArrayDeque<ItemStack>(resources.stream().filter(resourceAmount -> resourceAmount.resource() instanceof ItemResource).map(resourceAmount -> {
            ItemResource itemResource = (ItemResource)resourceAmount.resource();
            return itemResource.toItemStack(resourceAmount.amount());
        }).toList());
    }

    @Override
    public boolean isEmpty() {
        return this.capabilityCache.getItemHandler().map(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).isEmpty()) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    @Override
    public boolean applies(ResourceKey resource) {
        return resource instanceof ItemResource;
    }
}

