/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.datagen;

import com.refinedmods.refinedstorage.common.constructordestructor.AbstractConstructorDestructorBlock;
import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.controller.AbstractControllerBlock;
import com.refinedmods.refinedstorage.common.controller.ControllerEnergyType;
import com.refinedmods.refinedstorage.common.detector.DetectorBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkReceiverBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterState;
import com.refinedmods.refinedstorage.common.support.AbstractActiveColoredDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.direction.BiDirectionType;
import com.refinedmods.refinedstorage.common.support.direction.DefaultDirectionType;
import com.refinedmods.refinedstorage.common.support.direction.HorizontalDirection;
import com.refinedmods.refinedstorage.common.support.direction.HorizontalDirectionType;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockStateProviderImpl
extends BlockStateProvider {
    private static final String BLOCK_PREFIX = "block";
    private final ExistingFileHelper existingFileHelper;

    public BlockStateProviderImpl(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "refinedstorage", existingFileHelper);
        this.existingFileHelper = existingFileHelper;
    }

    protected void registerStatesAndModels() {
        this.registerCables();
        this.registerCableLike(Blocks.INSTANCE.getImporter(), "importer");
        this.registerCableLike(Blocks.INSTANCE.getExporter(), "exporter");
        this.registerCableLike(Blocks.INSTANCE.getExternalStorage(), "external_storage");
        this.registerControllers();
        this.registerGrids();
        this.registerDetectors();
        this.registerWirelessTransmitters();
        this.registerConstructorDestructor(Blocks.INSTANCE.getConstructor(), "constructor");
        this.registerConstructorDestructor(Blocks.INSTANCE.getDestructor(), "destructor");
        this.registerNetworkReceivers();
        this.registerNetworkTransmitters();
        this.registerSecurityManagers();
        this.registerRelays();
        this.registerDiskInterfaces();
        this.registerAutocrafters();
        this.registerAutocrafterManagers();
        this.registerAutocraftingMonitors();
    }

    private void registerCables() {
        Blocks.INSTANCE.getCable().forEach((color, id, block) -> {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.addModels(builder.partialState(), ConfiguredModel.builder().modelFile(this.getCableModel(color)).build());
        });
    }

    private void registerCableLike(BlockColorMap<?, ?> blockMap, String type) {
        ModelFile model = this.modelFile(IdentifierUtil.createIdentifier("block/" + type));
        blockMap.forEach((color, id, block) -> {
            MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block.get());
            ConfiguredModel.Builder cablePart = builder.part();
            cablePart.modelFile(this.getCableModel(color)).addModel();
            for (Direction direction : Direction.values()) {
                ConfiguredModel.Builder part = builder.part();
                BlockStateProviderImpl.addDirectionalRotation(direction, (ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)part);
                ((MultiPartBlockStateBuilder.PartBuilder)part.modelFile(model).addModel()).condition(DefaultDirectionType.FACE_CLICKED.getProperty(), (Comparable[])new Direction[]{direction});
            }
        });
    }

    private static void addDirectionalRotation(Direction direction, ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder> part) {
        switch (direction) {
            case UP: {
                part.rotationX(270);
                break;
            }
            case SOUTH: {
                part.rotationX(180);
                break;
            }
            case DOWN: {
                part.rotationX(90);
                break;
            }
            case WEST: {
                part.rotationY(270);
                break;
            }
            case EAST: {
                part.rotationY(90);
                break;
            }
        }
    }

    private void registerGrids() {
        Blocks.INSTANCE.getGrid().forEach((color, id, block) -> this.configureActiveColoredDirectionalBlock(color, block, "grid"));
        Blocks.INSTANCE.getCraftingGrid().forEach((color, id, block) -> this.configureActiveColoredDirectionalBlock(color, block, "crafting_grid"));
        Blocks.INSTANCE.getPatternGrid().forEach((color, id, block) -> this.configureActiveColoredDirectionalBlock(color, block, "pattern_grid"));
    }

    private void registerControllers() {
        Blocks.INSTANCE.getController().forEach((color, id, block) -> this.configureControllerVariants(color, block));
        Blocks.INSTANCE.getCreativeController().forEach((color, id, block) -> this.configureControllerVariants(color, block));
    }

    private void configureControllerVariants(DyeColor color, Supplier<? extends Block> block) {
        ModelFile off = this.modelFile(IdentifierUtil.createIdentifier("block/controller/off"));
        ModelFile nearlyOff = this.modelFile(IdentifierUtil.createIdentifier("block/controller/nearly_off"));
        ModelFile nearlyOn = this.modelFile(IdentifierUtil.createIdentifier("block/controller/nearly_on"));
        VariantBlockStateBuilder builder = this.getVariantBuilder(block.get());
        builder.addModels(builder.partialState().with(AbstractControllerBlock.ENERGY_TYPE, (Comparable)((Object)ControllerEnergyType.OFF)), new ConfiguredModel[]{ConfiguredModel.builder().modelFile(off).buildLast()});
        builder.addModels(builder.partialState().with(AbstractControllerBlock.ENERGY_TYPE, (Comparable)((Object)ControllerEnergyType.NEARLY_OFF)), new ConfiguredModel[]{ConfiguredModel.builder().modelFile(nearlyOff).buildLast()});
        builder.addModels(builder.partialState().with(AbstractControllerBlock.ENERGY_TYPE, (Comparable)((Object)ControllerEnergyType.NEARLY_ON)), new ConfiguredModel[]{ConfiguredModel.builder().modelFile(nearlyOn).buildLast()});
        builder.addModels(builder.partialState().with(AbstractControllerBlock.ENERGY_TYPE, (Comparable)((Object)ControllerEnergyType.ON)), new ConfiguredModel[]{ConfiguredModel.builder().modelFile(this.modelFile(IdentifierUtil.createIdentifier("block/controller/" + color.getName()))).buildLast()});
    }

    private void registerDetectors() {
        ModelFile unpowered = this.modelFile(IdentifierUtil.createIdentifier("block/detector/unpowered"));
        Blocks.INSTANCE.getDetector().forEach((color, id, block) -> {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.forAllStates(arg_0 -> this.lambda$registerDetectors$7(unpowered, (Supplier)block, arg_0));
        });
    }

    private void registerWirelessTransmitters() {
        ModelFile inactive = this.modelFile(IdentifierUtil.createIdentifier("block/wireless_transmitter/inactive"));
        Blocks.INSTANCE.getWirelessTransmitter().forEach((color, id, block) -> {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.forAllStates(blockState -> {
                ConfiguredModel.Builder model = ConfiguredModel.builder();
                if (Boolean.TRUE.equals(blockState.getValue((Property)AbstractActiveColoredDirectionalBlock.ACTIVE))) {
                    model.modelFile(this.modelFile(IdentifierUtil.createIdentifier("block/wireless_transmitter/" + color.getName())));
                } else {
                    model.modelFile(inactive);
                }
                Direction direction = (Direction)blockState.getValue(DefaultDirectionType.FACE_CLICKED.getProperty());
                this.addRotation(model, direction);
                return model.build();
            });
        });
    }

    private void registerConstructorDestructor(BlockColorMap<?, ?> blockMap, String type) {
        ModelFile activeModel = this.modelFile(IdentifierUtil.createIdentifier("block/" + type + "/active"));
        ModelFile inactiveModel = this.modelFile(IdentifierUtil.createIdentifier("block/" + type + "/inactive"));
        blockMap.forEach((color, id, block) -> {
            MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block.get());
            ConfiguredModel.Builder cablePart = builder.part();
            cablePart.modelFile(this.getCableModel(color)).addModel();
            for (Direction direction : Direction.values()) {
                ConfiguredModel.Builder part = builder.part();
                BlockStateProviderImpl.addDirectionalRotation(direction, (ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)part);
                ((MultiPartBlockStateBuilder.PartBuilder)part.modelFile(activeModel).addModel()).condition(DefaultDirectionType.FACE_CLICKED.getProperty(), (Comparable[])new Direction[]{direction}).condition((Property)AbstractConstructorDestructorBlock.ACTIVE, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)part.modelFile(inactiveModel).addModel()).condition(DefaultDirectionType.FACE_CLICKED.getProperty(), (Comparable[])new Direction[]{direction}).condition((Property)AbstractConstructorDestructorBlock.ACTIVE, (Comparable[])new Boolean[]{false}).end();
            }
        });
    }

    private ModelFile getCableModel(DyeColor color) {
        return this.modelFile(IdentifierUtil.createIdentifier("block/cable/" + color.getName()));
    }

    private ConfiguredModel[] registerDetector(ModelFile unpowered, DetectorBlock block, BlockState blockState) {
        ConfiguredModel.Builder model = ConfiguredModel.builder();
        if (Boolean.TRUE.equals(blockState.getValue((Property)DetectorBlock.POWERED))) {
            model.modelFile(this.modelFile(IdentifierUtil.createIdentifier("block/detector/" + block.getColor().getName())));
        } else {
            model.modelFile(unpowered);
        }
        Direction direction = (Direction)blockState.getValue(DefaultDirectionType.FACE_CLICKED.getProperty());
        this.addRotation(model, direction);
        return model.build();
    }

    private void registerNetworkReceivers() {
        ModelFile inactive = this.modelFile(IdentifierUtil.createIdentifier("block/network_receiver/inactive"));
        Blocks.INSTANCE.getNetworkReceiver().forEach((color, id, block) -> {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.forAllStates(blockState -> {
                ConfiguredModel.Builder model = ConfiguredModel.builder();
                if (Boolean.TRUE.equals(blockState.getValue((Property)NetworkReceiverBlock.ACTIVE))) {
                    model.modelFile(this.modelFile(IdentifierUtil.createIdentifier("block/network_receiver/" + color.getName())));
                } else {
                    model.modelFile(inactive);
                }
                return model.build();
            });
        });
    }

    private void registerNetworkTransmitters() {
        ModelFile inactive = this.modelFile(IdentifierUtil.createIdentifier("block/network_transmitter/inactive"));
        ModelFile error = this.modelFile(IdentifierUtil.createIdentifier("block/network_transmitter/error"));
        Blocks.INSTANCE.getNetworkTransmitter().forEach((color, id, block) -> {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.forAllStates(blockState -> {
                ConfiguredModel.Builder model = ConfiguredModel.builder();
                switch ((NetworkTransmitterState)((Object)((Object)((Object)blockState.getValue(NetworkTransmitterBlock.STATE))))) {
                    case ACTIVE: {
                        model.modelFile(this.modelFile(IdentifierUtil.createIdentifier("block/network_transmitter/" + color.getName())));
                        break;
                    }
                    case ERROR: {
                        model.modelFile(error);
                        break;
                    }
                    case INACTIVE: {
                        model.modelFile(inactive);
                    }
                }
                return model.build();
            });
        });
    }

    private void registerSecurityManagers() {
        ModelFile inactive = this.modelFile(IdentifierUtil.createIdentifier("block/security_manager/inactive"));
        Blocks.INSTANCE.getSecurityManager().forEach((color, id, block) -> {
            ModelFile active = this.modelFile(IdentifierUtil.createIdentifier("block/security_manager/" + color.getName()));
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.forAllStates(blockState -> {
                ConfiguredModel.Builder model = ConfiguredModel.builder();
                if (Boolean.TRUE.equals(blockState.getValue((Property)AbstractActiveColoredDirectionalBlock.ACTIVE))) {
                    model.modelFile(active);
                } else {
                    model.modelFile(inactive);
                }
                Direction direction = HorizontalDirectionType.INSTANCE.extractDirection((HorizontalDirection)((Object)((Object)((Object)blockState.getValue(HorizontalDirectionType.INSTANCE.getProperty())))));
                this.addRotationFrontFacingNorth(model, BiDirection.forHorizontal(direction));
                return model.build();
            });
        });
    }

    private void registerRelays() {
        ModelFile inactive = this.modelFile(IdentifierUtil.createIdentifier("block/relay/inactive"));
        Blocks.INSTANCE.getRelay().forEach((color, id, block) -> {
            ModelFile active = this.modelFile(IdentifierUtil.createIdentifier("block/relay/" + color.getName()));
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.forAllStates(blockState -> {
                ConfiguredModel.Builder model = ConfiguredModel.builder();
                if (Boolean.TRUE.equals(blockState.getValue((Property)AbstractActiveColoredDirectionalBlock.ACTIVE))) {
                    model.modelFile(active);
                } else {
                    model.modelFile(inactive);
                }
                Direction direction = (Direction)blockState.getValue(DefaultDirectionType.FACE_CLICKED.getProperty());
                BiDirection biDirection = BiDirection.forDirection(direction);
                this.addRotationFrontFacingNorth(model, biDirection);
                return model.build();
            });
        });
    }

    private void registerDiskInterfaces() {
        Blocks.INSTANCE.getDiskInterface().forEach((color, id, block) -> {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.addModels(builder.partialState(), ConfiguredModel.builder().modelFile(this.modelFile(IdentifierUtil.createIdentifier("block/disk_interface/" + color.getName()))).build());
        });
    }

    private void registerAutocrafters() {
        ModelFile inactive = this.modelFile(IdentifierUtil.createIdentifier("block/autocrafter/inactive"));
        Blocks.INSTANCE.getAutocrafter().forEach((color, id, block) -> {
            ModelFile active = this.modelFile(IdentifierUtil.createIdentifier("block/autocrafter/" + color.getName()));
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.forAllStates(blockState -> {
                ConfiguredModel.Builder model = ConfiguredModel.builder();
                if (Boolean.TRUE.equals(blockState.getValue((Property)AbstractActiveColoredDirectionalBlock.ACTIVE))) {
                    model.modelFile(active);
                } else {
                    model.modelFile(inactive);
                }
                Direction direction = (Direction)blockState.getValue(DefaultDirectionType.FACE_CLICKED.getProperty());
                this.addAutocrafterRotation(model, direction);
                return model.build();
            });
        });
    }

    private void registerAutocrafterManagers() {
        Blocks.INSTANCE.getAutocrafterManager().forEach((color, id, block) -> this.configureActiveColoredDirectionalBlock(color, block, "autocrafter_manager"));
    }

    private void registerAutocraftingMonitors() {
        Blocks.INSTANCE.getAutocraftingMonitor().forEach((color, id, block) -> this.configureActiveColoredDirectionalBlock(color, block, "autocrafting_monitor"));
    }

    private void configureActiveColoredDirectionalBlock(DyeColor color, Supplier<? extends Block> block, String name) {
        ModelFile inactive = this.modelFile(IdentifierUtil.createIdentifier("block/" + name + "/inactive"));
        ModelFile active = this.modelFile(IdentifierUtil.createIdentifier("block/" + name + "/" + color.getName()));
        VariantBlockStateBuilder builder = this.getVariantBuilder(block.get());
        builder.forAllStates(blockState -> {
            ConfiguredModel.Builder model = ConfiguredModel.builder();
            if (Boolean.TRUE.equals(blockState.getValue((Property)AbstractActiveColoredDirectionalBlock.ACTIVE))) {
                model.modelFile(active);
            } else {
                model.modelFile(inactive);
            }
            BiDirection direction = (BiDirection)((Object)((Object)blockState.getValue(BiDirectionType.INSTANCE.getProperty())));
            this.addRotationFrontFacingNorth(model, direction);
            return model.build();
        });
    }

    private void addRotation(ConfiguredModel.Builder<?> model, Direction direction) {
        int rotationX = direction.getAxis() == Direction.Axis.Y ? (direction == Direction.UP ? 180 : 0) : (direction.getAxis().isHorizontal() ? 90 : 0);
        int rotationY = direction.getAxis().isVertical() ? 0 : (int)direction.toYRot() % 360;
        model.rotationX(rotationX);
        model.rotationY(rotationY);
    }

    private void addRotationFrontFacingNorth(ConfiguredModel.Builder<?> model, BiDirection direction) {
        int x = (int)direction.getVec().x();
        int y = (int)direction.getVec().y();
        int z = (int)direction.getVec().z();
        switch (direction) {
            case UP_EAST: 
            case UP_NORTH: 
            case UP_SOUTH: 
            case UP_WEST: 
            case DOWN_EAST: 
            case DOWN_WEST: 
            case DOWN_SOUTH: 
            case DOWN_NORTH: {
                model.rotationX(x * -1).rotationY(z);
                break;
            }
            case EAST: 
            case WEST: {
                model.rotationY(y + 180);
                break;
            }
            case NORTH: 
            case SOUTH: {
                model.rotationY(y);
            }
        }
    }

    private void addAutocrafterRotation(ConfiguredModel.Builder<?> model, Direction direction) {
        if (direction.getAxis().isHorizontal()) {
            model.rotationX(90);
        } else if (direction == Direction.DOWN) {
            model.rotationX(180);
        }
        model.rotationY(direction.getAxis().isVertical() ? 0 : ((int)direction.toYRot() + 180) % 360);
    }

    private ModelFile modelFile(ResourceLocation location) {
        return new ModelFile.ExistingModelFile(location, this.existingFileHelper);
    }

    private /* synthetic */ ConfiguredModel[] lambda$registerDetectors$7(ModelFile unpowered, Supplier block, BlockState blockState) {
        return this.registerDetector(unpowered, (DetectorBlock)block.get(), blockState);
    }
}

