/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.debug;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;
import org.joml.Matrix4f;

public final class NetworkDebugRenderer {
    private NetworkDebugRenderer() {
    }

    @SubscribeEvent
    public static void renderDebugOverlay(AddSectionGeometryEvent e) {
        BlockPos regionOrigin = e.getSectionOrigin().immutable();
        e.addRenderer(ctx -> {
            VertexConsumer buf = ctx.getOrCreateChunkBuffer(RenderType.translucent());
            BlockPos.betweenClosed((BlockPos)regionOrigin, (BlockPos)regionOrigin.offset(16, 16, 16)).forEach(pos -> NetworkDebugRenderer.renderAt(ctx, pos, regionOrigin, buf));
        });
    }

    private static void renderAt(AddSectionGeometryEvent.SectionRenderingContext ctx, BlockPos pos, BlockPos regionOrigin, VertexConsumer buf) {
        BlockEntity blockEntity = ctx.getRegion().getBlockEntity(pos);
        if (!(blockEntity instanceof AbstractBaseNetworkNodeContainerBlockEntity)) {
            return;
        }
        AbstractBaseNetworkNodeContainerBlockEntity container = (AbstractBaseNetworkNodeContainerBlockEntity)blockEntity;
        ctx.getPoseStack().pushPose();
        ctx.getPoseStack().translate((float)pos.getX() - (float)regionOrigin.getX(), (float)pos.getY() - (float)regionOrigin.getY(), (float)pos.getZ() - (float)regionOrigin.getZ());
        int color = NetworkDebugRenderer.getColorFromId(container.getDebugNetworkId());
        Matrix4f mat = ctx.getPoseStack().last().pose();
        float max = 1.01f;
        float min = -0.01f;
        buf.addVertex(mat, -0.01f, 1.01f, -0.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, -0.01f, 1.01f, 1.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, 1.01f, 1.01f, 1.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, 1.01f, 1.01f, -0.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, -0.01f, 1.01f, -0.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, 1.01f, 1.01f, -0.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, 1.01f, -0.01f, -0.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, -0.01f, -0.01f, -0.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, 1.01f, 1.01f, 1.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, -0.01f, 1.01f, 1.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, -0.01f, -0.01f, 1.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, 1.01f, -0.01f, 1.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, -0.01f, 1.01f, 1.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, -0.01f, 1.01f, -0.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, -0.01f, -0.01f, -0.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, -0.01f, -0.01f, 1.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, 1.01f, -0.01f, 1.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, 1.01f, -0.01f, -0.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, 1.01f, 1.01f, -0.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, 1.01f, 1.01f, 1.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, 1.01f, -0.01f, -0.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, 1.01f, -0.01f, 1.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, -0.01f, -0.01f, 1.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        buf.addVertex(mat, -0.01f, -0.01f, -0.01f).setUv(-100.0f, -100.0f).setNormal(0.0f, 0.0f, 0.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        ctx.getPoseStack().popPose();
    }

    private static int getColorFromId(int id) {
        if (id == -1) {
            return -16777216;
        }
        byte[] hash = NetworkDebugRenderer.getIdHash(id);
        int r = Byte.toUnsignedInt(hash[0]);
        int g = Byte.toUnsignedInt(hash[1]);
        int b = Byte.toUnsignedInt(hash[2]);
        int a = 128;
        return Integer.MIN_VALUE | r << 16 | g << 8 | b;
    }

    private static byte[] getIdHash(int id) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] input = ByteBuffer.allocate(4).putInt(id).array();
            return md.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

