/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.storage;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.refinedmods.refinedstorage.api.storage.StorageState;
import com.refinedmods.refinedstorage.common.storage.AbstractDiskContainerBlockEntity;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.neoforge.support.render.ItemBakedModel;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.joml.Vector3f;

public class DiskContainerItemOverrides<T>
extends ItemOverrides {
    private final LoadingCache<T, BakedModel> cache = CacheBuilder.newBuilder().build(CacheLoader.from(cacheKey -> new ItemBakedModel(originalModel, (List)blockCache.getUnchecked(cacheKey), Map.of(Direction.NORTH, (List)blockCache.getUnchecked(cacheKeySideFactory.apply(cacheKey, Direction.NORTH)), Direction.EAST, (List)blockCache.getUnchecked(cacheKeySideFactory.apply(cacheKey, Direction.EAST)), Direction.SOUTH, (List)blockCache.getUnchecked(cacheKeySideFactory.apply(cacheKey, Direction.SOUTH)), Direction.WEST, (List)blockCache.getUnchecked(cacheKeySideFactory.apply(cacheKey, Direction.WEST)), Direction.UP, (List)blockCache.getUnchecked(cacheKeySideFactory.apply(cacheKey, Direction.UP)), Direction.DOWN, (List)blockCache.getUnchecked(cacheKeySideFactory.apply(cacheKey, Direction.DOWN))))));
    private final BakedModel originalModel;
    private final Vector3f[] diskTranslations;
    private final Function<Disk[], T> cacheKeyFactory;

    public DiskContainerItemOverrides(LoadingCache<T, List<BakedQuad>> blockCache, BakedModel originalModel, Vector3f[] diskTranslations, Function<Disk[], T> cacheKeyFactory, BiFunction<T, Direction, T> cacheKeySideFactory) {
        this.originalModel = originalModel;
        this.diskTranslations = diskTranslations;
        this.cacheKeyFactory = cacheKeyFactory;
    }

    @Nullable
    public BakedModel resolve(BakedModel bakedModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData == null || level == null) {
            return this.originalModel.getOverrides().resolve(bakedModel, stack, level, entity, seed);
        }
        Disk[] disks = new Disk[this.diskTranslations.length];
        for (int i = 0; i < this.diskTranslations.length; ++i) {
            Item diskItem;
            disks[i] = new Disk(diskItem, (diskItem = AbstractDiskContainerBlockEntity.getDisk(customData.getUnsafe(), i, (HolderLookup.Provider)level.registryAccess())) == null ? StorageState.NONE : StorageState.INACTIVE);
        }
        return (BakedModel)this.cache.getUnchecked(this.cacheKeyFactory.apply(disks));
    }
}

