/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.blocks;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.infusable.ItemInfusable;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.blazing.BlazingConfiguration;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.data.AgitatorData;
import mcjty.rftoolspower.modules.blazing.items.BlazingRod;
import mcjty.rftoolspower.modules.blazing.items.BlazingRodStack;
import mcjty.rftoolspower.modules.blazing.logic.BlazingAgitatorAlgorithm;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.Lazy;

public class BlazingAgitatorTileEntity
extends TickingTileEntity {
    public static final int BUFFER_SIZE = 9;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(18).box(SlotDefinition.specific(BlazingAgitatorTileEntity::isValidBlazingRod).in(), 0, 28, 7, 3, 3).box(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlazingModule.BLAZING_ROD.get())}).out(), 9, 117, 7, 3, 3).playerSlots(10, 70));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).slotLimit(1).itemValid((slot, stack) -> BlazingAgitatorTileEntity.isValidBlazingRod(stack)).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<BlazingAgitatorTileEntity, GenericItemHandler> ITEM_CAP = be -> be.items;
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)BlazingConfiguration.AGITATOR_MAXENERGY.get()).intValue(), (long)((Integer)BlazingConfiguration.AGITATOR_ENERGY_INPUT_PERTICK.get()).intValue());
    @Cap(type=CapType.ENERGY)
    private static final Function<BlazingAgitatorTileEntity, GenericEnergyStorage> ENERGY_CAP = be -> be.energyStorage;
    private final DefaultInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.INFUSABLE)
    private static final Function<BlazingAgitatorTileEntity, IInfusable> INFUSABLE_CAP = be -> be.infusable;
    @Cap(type=CapType.CONTAINER)
    private static final Function<BlazingAgitatorTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Blazing Agitator").containerSupplier(DefaultContainerProvider.container(BlazingModule.CONTAINER_BLAZING_AGITATOR, CONTAINER_FACTORY, (GenericTileEntity)be)).itemHandler(() -> be.items).energyHandler(() -> be.energyStorage).setupSync((GenericTileEntity)be);
    public static final VoxelShape SLAB = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_00 = Value.create((String)"lock00", (Type)Type.BOOLEAN, te -> te.isLocked(0, 0), (te, v) -> te.setLocked(0, 0, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_01 = Value.create((String)"lock01", (Type)Type.BOOLEAN, te -> te.isLocked(0, 1), (te, v) -> te.setLocked(0, 1, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_02 = Value.create((String)"lock02", (Type)Type.BOOLEAN, te -> te.isLocked(0, 2), (te, v) -> te.setLocked(0, 2, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_10 = Value.create((String)"lock10", (Type)Type.BOOLEAN, te -> te.isLocked(1, 0), (te, v) -> te.setLocked(1, 0, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_11 = Value.create((String)"lock11", (Type)Type.BOOLEAN, te -> te.isLocked(1, 1), (te, v) -> te.setLocked(1, 1, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_12 = Value.create((String)"lock12", (Type)Type.BOOLEAN, te -> te.isLocked(1, 2), (te, v) -> te.setLocked(1, 2, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_20 = Value.create((String)"lock20", (Type)Type.BOOLEAN, te -> te.isLocked(2, 0), (te, v) -> te.setLocked(2, 0, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_21 = Value.create((String)"lock21", (Type)Type.BOOLEAN, te -> te.isLocked(2, 1), (te, v) -> te.setLocked(2, 1, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_22 = Value.create((String)"lock22", (Type)Type.BOOLEAN, te -> te.isLocked(2, 2), (te, v) -> te.setLocked(2, 2, (boolean)v));
    private final float[] rotationSpeed = new float[9];
    private final float[] currentAngle = new float[9];
    private int updateSpeedCounter = 10;
    private final BlazingAgitatorAlgorithm algorithm = new BlazingAgitatorAlgorithm(slot -> new BlazingRodStack(this.items.getStackInSlot(slot.intValue())));

    public BlazingAgitatorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlazingModule.BLAZING_AGITATOR.be().get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.METAL)).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbase:powergeneration/blazingagitator")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}).tileEntitySupplier(BlazingAgitatorTileEntity::new)){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }

            @Nonnull
            public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
                return SLAB;
            }
        };
    }

    private static boolean isValidBlazingRod(ItemStack stack) {
        if (stack.getItem() == Items.BLAZE_ROD) {
            return true;
        }
        if (stack.getItem() == BlazingModule.BLAZING_ROD.get()) {
            return BlazingRod.getInfusionStepsLeft(stack) >= 64;
        }
        return false;
    }

    public void saveClientDataToNBT(CompoundTag tag, HolderLookup.Provider provider) {
        for (int i = 0; i < 9; ++i) {
            tag.putFloat("rs" + i, this.rotationSpeed[i]);
        }
        this.items.save(tag, "items", provider);
    }

    public void loadClientDataFromNBT(CompoundTag tag, HolderLookup.Provider provider) {
        for (int i = 0; i < 9; ++i) {
            this.rotationSpeed[i] = tag.getFloat("rs" + i);
        }
        this.items.load(tag, "items", provider);
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected void tickServer() {
        boolean active = false;
        if (this.isMachineEnabled() && this.energyStorage.getEnergy() >= (long)((Integer)BlazingConfiguration.AGITATOR_USE_PER_TICK.get()).intValue()) {
            this.energyStorage.consumeEnergy((long)((Integer)BlazingConfiguration.AGITATOR_USE_PER_TICK.get()).intValue());
            active = true;
            this.tickRods();
        }
        this.updateClientRotationSpeed(active);
    }

    private void tickRods() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() == Items.BLAZE_ROD) {
                this.items.setStackInSlot(i, new ItemStack((ItemLike)BlazingModule.BLAZING_ROD.get()));
            } else {
                AgitatorData data = (AgitatorData)this.getData(BlazingModule.AGITATOR_DATA);
                float timeLeft = BlazingRod.getAgitationTimeLeft(stack);
                if (timeLeft > 0.0f) {
                    this.algorithm.tickBlazingRod(i, new BlazingRodStack(stack), timeLeft, this.infusable.getInfusedFactor());
                } else if (!data.isLocked(i)) {
                    this.moveToOutput(i, stack);
                }
            }
            this.markDirtyQuick();
        }
    }

    private void updateClientRotationSpeed(boolean active) {
        --this.updateSpeedCounter;
        if (this.updateSpeedCounter < 0) {
            this.updateSpeedCounter = 10;
            boolean changed = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack;
                float newspeed = 0.0f;
                if (active && !(stack = this.items.getStackInSlot(i)).isEmpty()) {
                    float percentage = BlazingRod.getAgitationTimePercentage(stack);
                    newspeed = percentage / 50.0f;
                }
                if (!((double)Math.abs(newspeed - this.rotationSpeed[i]) > 0.01)) continue;
                this.rotationSpeed[i] = newspeed;
                changed = true;
            }
            if (changed) {
                BlockState state = this.getBlockState();
                this.level.sendBlockUpdated(this.worldPosition, state, state, 6);
            }
        }
    }

    private void moveToOutput(int i, ItemStack stack) {
        for (int j = 9; j < 18; ++j) {
            if (!this.items.getStackInSlot(j).isEmpty()) continue;
            this.items.setStackInSlot(i, ItemStack.EMPTY);
            this.items.setStackInSlot(j, stack);
            return;
        }
    }

    public float getCurrentAngle(int x, int y) {
        return this.currentAngle[y * 3 + x];
    }

    public void setCurrentAngle(int x, int y, float currentAngle) {
        this.currentAngle[y * 3 + x] = currentAngle;
    }

    public float getRotationSpeed(int x, int y) {
        return this.rotationSpeed[y * 3 + x];
    }

    public boolean isLocked(int x, int y) {
        AgitatorData data = (AgitatorData)this.getData(BlazingModule.AGITATOR_DATA);
        return data.isLocked(y * 3 + x);
    }

    public void setLocked(int x, int y, boolean v) {
        AgitatorData data = (AgitatorData)this.getData(BlazingModule.AGITATOR_DATA);
        data = data.setLocked(y * 3 + x, v);
        this.setData(BlazingModule.AGITATOR_DATA, data);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.items.save(tag, "items", provider);
        this.energyStorage.save(tag, "energy", provider);
        this.infusable.save(tag, "infusable");
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items.load(tag, "items", provider);
        this.energyStorage.load(tag, "energy", provider);
        this.infusable.load(tag, "infusable");
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        AgitatorData data = (AgitatorData)input.get(BlazingModule.ITEM_AGITATOR_DATA);
        if (data != null) {
            this.setData(BlazingModule.AGITATOR_DATA, data);
        }
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.infusable.applyImplicitComponents((ItemInfusable)input.get((Supplier)Registration.ITEM_INFUSABLE));
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(BlazingModule.ITEM_AGITATOR_DATA, (Object)((AgitatorData)this.getData(BlazingModule.AGITATOR_DATA)));
        this.energyStorage.collectImplicitComponents(builder);
        this.infusable.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
    }
}

