/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.powercell.blocks;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.crafting.IComponentsToPreserve;
import mcjty.lib.setup.Registration;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.powercell.PowerCellConfig;
import mcjty.rftoolspower.modules.powercell.PowerCellModule;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellTileEntity;
import mcjty.rftoolspower.modules.powercell.data.Tier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class PowerCellBlock
extends BaseBlock
implements IComponentsToPreserve {
    public static final BooleanProperty UPPER = BooleanProperty.create((String)"upper");
    public static final BooleanProperty LOWER = BooleanProperty.create((String)"lower");

    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    public PowerCellBlock(Tier tier) {
        super(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"info", stack -> {
            long power = PowerCellBlock.getEnergy(stack);
            long totpower = 0L;
            if (stack.getItem() == PowerCellModule.CELL1.item().get()) {
                totpower = PowerCellTileEntity.safeCast(PowerCellConfig.TIER1_MAXRF.get());
            } else if (stack.getItem() == PowerCellModule.CELL2.item().get()) {
                totpower = PowerCellTileEntity.safeCast(PowerCellConfig.TIER2_MAXRF.get());
            } else if (stack.getItem() == PowerCellModule.CELL3.item().get()) {
                totpower = PowerCellTileEntity.safeCast(PowerCellConfig.TIER3_MAXRF.get());
            }
            return power + " (max " + totpower + " RF/FE)";
        })}).tileEntitySupplier((pos, state) -> new PowerCellTileEntity(tier, pos, state)));
    }

    private static long getEnergy(ItemStack stack) {
        ItemEnergy energy = (ItemEnergy)stack.get((Supplier)Registration.ITEM_ENERGY);
        if (energy != null) {
            return energy.energy();
        }
        return 0L;
    }

    public void setPlacedBy(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        BlockEntity te;
        super.setPlacedBy(world, pos, state, placer, stack);
        if (!world.isClientSide && (te = world.getBlockEntity(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            long energy = PowerCellBlock.getEnergy(stack);
            powercell.setLocalEnergy(energy);
            powercell.getNetwork();
            powercell.markDirtyQuick();
        }
    }

    protected boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        BlockEntity te;
        if (!world.isClientSide && (te = world.getBlockEntity(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            powercell.toggleMode(side);
        }
        return true;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        BlockState state = super.getStateForPlacement(context);
        Level world = context.getLevel();
        return (BlockState)((BlockState)state.setValue((Property)UPPER, (Comparable)Boolean.valueOf(world.getBlockState((pos = context.getClickedPos()).above()).getBlock() == this))).setValue((Property)LOWER, (Comparable)Boolean.valueOf(world.getBlockState(pos.below()).getBlock() == this));
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (facing == Direction.UP) {
            return (BlockState)stateIn.setValue((Property)UPPER, (Comparable)Boolean.valueOf(facingState.getBlock() == this));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.setValue((Property)LOWER, (Comparable)Boolean.valueOf(facingState.getBlock() == this));
        }
        return stateIn;
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{UPPER, LOWER});
    }

    @Nonnull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public Collection<DataComponentType<?>> getComponentsToPreserve() {
        return List.of((DataComponentType)Registration.ITEM_ENERGY.get());
    }
}

