/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.MonkeyEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MonkeySittingModel<T extends MonkeyEntity>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart BodyTop;
    private final ModelPart Head;

    public MonkeySittingModel(ModelPart root) {
        this.Body = root.getChild("Body");
        this.BodyTop = this.Body.getChild("BodyTop");
        this.Head = this.BodyTop.getChild("Head");
    }

    public void setupAnim(MonkeyEntity monkey, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (monkey.isPartying()) {
            this.Head.xRot = 1.4835f + Mth.cos((float)(ageInTicks * 0.4f)) * 0.3f;
            this.Head.zRot = 0.0f;
            this.BodyTop.yRot = Mth.cos((float)(ageInTicks * 0.2f)) * 0.175f;
        } else {
            this.Head.xRot = 1.4835f + this.deg2rad(headPitch);
            this.Head.zRot = this.deg2rad(netHeadYaw);
            this.BodyTop.yRot = 0.0f;
        }
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        if (this.young) {
            matrixStackIn.scale(0.5f, 0.5f, 0.5f);
            matrixStackIn.translate(0.0, 1.5, 0.0);
        }
        this.Body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 14).addBox(-3.0f, -2.1468f, -5.0E-4f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.117f, (float)0.9453f, (float)-1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition BackRightLegTop = Body.addOrReplaceChild("BackRightLegTop", CubeListBuilder.create().texOffs(15, 0).addBox(-1.0f, -1.4f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)1.0209f, (float)4.0362f, (float)-0.0436f, (float)0.0436f, (float)0.5672f));
        PartDefinition BackRightLegBottom = BackRightLegTop.addOrReplaceChild("BackRightLegBottom", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -0.45f, -0.925f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 30).addBox(-1.0f, 3.55f, -1.925f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5388f, (float)2.1947f, (float)-0.0614f, (float)0.0f, (float)0.0f, (float)-1.4835f));
        PartDefinition BackLeftLegTop = Body.addOrReplaceChild("BackLeftLegTop", CubeListBuilder.create().texOffs(15, 0).addBox(-1.0f, -1.475f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.95f, (float)0.9675f, (float)3.9196f, (float)-0.0697f, (float)-0.008f, (float)-0.6557f));
        PartDefinition BackLeftLegBottom = BackLeftLegTop.addOrReplaceChild("BackLeftLegBottom", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -0.525f, -0.9f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 30).addBox(-1.0f, 3.475f, -1.9f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2656f, (float)1.7932f, (float)0.0215f, (float)1.309f, (float)-1.5708f, (float)0.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(18, 20).addBox(-1.0f, -1.1f, 0.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0106f, (float)4.1315f, (float)1.4835f, (float)0.0f, (float)-0.1745f));
        PartDefinition Tail2 = Tail.addOrReplaceChild("Tail2", CubeListBuilder.create().texOffs(22, 14).addBox(-0.4898f, -0.4184f, 0.0203f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0102f, (float)-0.1211f, (float)4.3435f, (float)0.0436f, (float)-0.6981f, (float)0.0f));
        PartDefinition Tail3 = Tail2.addOrReplaceChild("Tail3", CubeListBuilder.create().texOffs(18, 13).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0268f, (float)0.0709f, (float)4.0296f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        PartDefinition BodyTop = Body.addOrReplaceChild("BodyTop", CubeListBuilder.create().texOffs(0, 23).addBox(-3.0f, -2.0076f, -5.0365f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.1619f, (float)0.3208f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Head = BodyTop.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 5).addBox(-2.5f, -5.0f, -1.9965f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.3827f, (float)-4.8802f, (float)1.4835f, (float)0.0f, (float)0.0f));
        PartDefinition MouthTop = Head.addOrReplaceChild("MouthTop", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.125f, -2.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.9009f, (float)-1.2519f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition MouthBottom = Head.addOrReplaceChild("MouthBottom", CubeListBuilder.create().texOffs(19, 8).addBox(-1.5f, -0.625f, -2.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.6598f, (float)-1.0705f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition EarRight = Head.addOrReplaceChild("EarRight", CubeListBuilder.create().texOffs(28, 21).addBox(-0.5f, -1.1f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-3.0378f, (float)0.037f));
        PartDefinition EarLeft = Head.addOrReplaceChild("EarLeft", CubeListBuilder.create().texOffs(28, 21).addBox(-0.5f, -1.1f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-3.0378f, (float)0.037f));
        PartDefinition FrontRightLegTop = BodyTop.addOrReplaceChild("FrontRightLegTop", CubeListBuilder.create().texOffs(15, 0).addBox(-1.3215f, -1.4728f, -1.059f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.675f, (float)0.2566f, (float)-2.8141f, (float)0.4038f, (float)-0.8178f, (float)0.7357f));
        PartDefinition FrontRightLegBottom = FrontRightLegTop.addOrReplaceChild("FrontRightLegBottom", CubeListBuilder.create().texOffs(24, 0).addBox(-0.5958f, -1.3258f, -0.934f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 30).addBox(-0.5958f, 2.6742f, -1.934f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.136f, (float)2.4769f, (float)-0.0749f, (float)0.0f, (float)0.0f, (float)-1.1781f));
        PartDefinition FrontLeftLegTop = BodyTop.addOrReplaceChild("FrontLeftLegTop", CubeListBuilder.create().texOffs(15, 0).addBox(-1.0f, -0.875f, -1.2f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.55f, (float)0.3021f, (float)-2.7148f, (float)0.4911f, (float)-1.1232f, (float)-1.3466f));
        PartDefinition FrontLeftLegBottom = FrontLeftLegTop.addOrReplaceChild("FrontLeftLegBottom", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0588f, -0.0608f, -1.0545f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 30).addBox(-1.0588f, 3.9392f, -2.0545f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0641f, (float)2.2424f, (float)-0.8784f, (float)1.5708f, (float)0.2618f, (float)1.5708f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }
}

