/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tristankechlo.livingthings.client.LivingThingsClient;
import com.tristankechlo.livingthings.client.ModelLayer;
import com.tristankechlo.livingthings.client.model.entity.MonkeyModel;
import com.tristankechlo.livingthings.client.model.entity.MonkeySittingModel;
import com.tristankechlo.livingthings.entity.MonkeyEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class MonkeyRenderer
extends MobRenderer<MonkeyEntity, EntityModel<MonkeyEntity>> {
    private static final ResourceLocation TEXTURE = LivingThingsClient.getEntityTexture("monkey/monkey.png");
    private final MonkeyModel<MonkeyEntity> modelNormal;
    private final MonkeySittingModel<MonkeyEntity> modelSitting;
    private byte lastAction;

    public MonkeyRenderer(EntityRendererProvider.Context context) {
        super(context, new MonkeyModel(context.bakeLayer(ModelLayer.MONKEY)), 0.35f);
        this.modelNormal = new MonkeyModel(context.bakeLayer(ModelLayer.MONKEY));
        this.modelSitting = new MonkeySittingModel(context.bakeLayer(ModelLayer.MONKEY_SITTING));
    }

    public ResourceLocation getTextureLocation(MonkeyEntity entity) {
        return TEXTURE;
    }

    public void render(MonkeyEntity monkey, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        byte monkeyAction = (byte)(monkey.isInSittingPose() ? 1 : 0);
        if (monkeyAction != this.lastAction) {
            this.model = monkeyAction == 1 ? this.modelSitting : this.modelNormal;
        }
        this.lastAction = monkeyAction;
        super.render((LivingEntity)monkey, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }
}

