/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.livingthings.config.entity.LionConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.entity.misc.IGenderedMob;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class LionEntity
extends Animal
implements NeutralMob,
IMobVariants,
IGenderedMob,
ILexiconEntry {
    private static final EntityDataAccessor<Boolean> MALE = SynchedEntityData.defineId(LionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> LION_VARIANT = SynchedEntityData.defineId(LionEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final UniformInt rangedInteger = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public LionEntity(EntityType<? extends LionEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static boolean checkLionSpawnRules(EntityType<LionEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(LivingThingsTags.LION_SPAWNABLE_ON) && LionEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entityIn) {
        LionEntity entityChild = (LionEntity)ModEntityTypes.LION.get().create(this.level());
        entityChild.setGender(LionEntity.getWeightedRandomGender(this.random));
        entityChild.setVariant(this.getVariantFromParents((AgeableMob)this, entityIn));
        return entityChild;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        this.setGender(LionEntity.getWeightedRandomGender(this.random));
        int color1Weight = (Integer)LionConfig.get().color1Weight.get();
        int colorWhiteWeight = (Integer)LionConfig.get().colorWhiteWeight.get();
        byte variant = this.getRandomVariant(this.random, new byte[]{0, 1}, new int[]{color1Weight, colorWhiteWeight});
        this.setVariant(variant);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public static IGenderedMob.Gender getWeightedRandomGender(RandomSource random) {
        int maleWeight = (Integer)LionConfig.get().maleWeight.get();
        int femaleWeight = (Integer)LionConfig.get().femaleWeight.get();
        if (maleWeight <= 0 && femaleWeight <= 0) {
            return random.nextBoolean() ? IGenderedMob.Gender.MALE : IGenderedMob.Gender.FEMALE;
        }
        Optional gender = WeightedRandom.getRandomItem((RandomSource)random, (List)ImmutableList.of((Object)new IGenderedMob.WeightedGender(Math.max(0, maleWeight), IGenderedMob.Gender.MALE), (Object)new IGenderedMob.WeightedGender(Math.max(0, femaleWeight), IGenderedMob.Gender.FEMALE)));
        return ((IGenderedMob.WeightedGender)gender.get()).gender;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, LionConfig.health()).add(Attributes.MOVEMENT_SPEED, LionConfig.movementSpeed()).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, LionConfig.attackDamage());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BetterMeleeAttackGoal((PathfinderMob)this, 1.1, false, LionConfig::canAttack));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 0.95));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 7.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, null));
        this.targetSelector.addGoal(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MALE, (Object)false);
        builder.define(LION_VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getGender() == IGenderedMob.Gender.MALE) {
            compound.putBoolean("IsMale", true);
        }
        compound.putByte("LionVariant", this.getVariant());
        this.addPersistentAngerSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.getBoolean("IsMale")) {
            this.setGender(IGenderedMob.Gender.MALE);
        } else {
            this.setGender(IGenderedMob.Gender.FEMALE);
        }
        this.setVariant(compound.getByte("LionVariant"));
        this.readPersistentAngerSaveData(this.level(), compound);
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(1.8);
    }

    public boolean canMate(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof LionEntity) {
            LionEntity otherLion = (LionEntity)otherAnimal;
            if (this.getGender() != otherLion.getGender()) {
                return this.isInLove() && otherLion.isInLove();
            }
        }
        return false;
    }

    protected float getWaterSlowDown() {
        return 0.85f;
    }

    public boolean isFood(ItemStack stack) {
        boolean isMeat = stack.has(DataComponents.FOOD) && stack.is(ItemTags.MEAT);
        return stack.is(LivingThingsTags.LION_FOOD) || LionConfig.allowAllMeatAsFood() && isMeat;
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.LION_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return ModSounds.LION_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.LION_DEATH.get();
    }

    public int getMaxSpawnClusterSize() {
        return LionConfig.maxSpawnedInChunk();
    }

    @Override
    public IGenderedMob.Gender getGender() {
        if (((Boolean)this.getEntityData().get(MALE)).booleanValue()) {
            return IGenderedMob.Gender.MALE;
        }
        return IGenderedMob.Gender.FEMALE;
    }

    @Override
    public void setGender(IGenderedMob.Gender gender) {
        if (gender == IGenderedMob.Gender.MALE) {
            this.getEntityData().set(MALE, (Object)true);
        } else {
            this.getEntityData().set(MALE, (Object)false);
        }
    }

    @Override
    public byte getVariant() {
        return (Byte)this.getEntityData().get(LION_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.getEntityData().set(LION_VARIANT, (Object)variant);
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.angerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(rangedInteger.sample(this.random));
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.LION;
    }
}

