/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.ShroomieConfig;
import com.tristankechlo.livingthings.entity.ai.ShroomiePlantMushroomGoal;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootTable;

public class ShroomieEntity
extends Animal
implements IMobVariants,
ILexiconEntry {
    private static final ResourceKey<LootTable> LOOTTABLE_RED = ShroomieEntity.createLootTableRK("entities/shroomie_red");
    private static final ResourceKey<LootTable> LOOTTABLE_BROWN = ShroomieEntity.createLootTableRK("entities/shroomie_brown");
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.defineId(ShroomieEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final UniformInt RANGED_INTEGER = TimeUtil.rangeOfSeconds((int)30, (int)60);
    private boolean hasMushroom = false;
    private int mushroomCooldown;

    public ShroomieEntity(EntityType<? extends ShroomieEntity> entityType, Level world) {
        super(entityType, world);
    }

    public static boolean checkShroomieSpawnRules(EntityType<ShroomieEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(LivingThingsTags.SHROOMIE_SPAWNABLE_ON) && ShroomieEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(tag.getByte("ShroomieType"));
        this.mushroomCooldown = tag.getInt("MushroomCooldown");
        this.hasMushroom = tag.getBoolean("CanPlantMushroom");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("ShroomieType", this.getVariant());
        tag.putInt("MushroomCooldown", this.mushroomCooldown);
        tag.putBoolean("CanPlantMushroom", this.hasMushroom);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredients.SHROOMIE_FOOD, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new ShroomiePlantMushroomGoal(this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.mushroomCooldown > 0) {
            --this.mushroomCooldown;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData data) {
        int brownWeight = (Integer)ShroomieConfig.get().colorBrownWeight.get();
        int redWeight = (Integer)ShroomieConfig.get().colorRedWeight.get();
        this.setVariant(this.getRandomVariant(this.random, new byte[]{0, 1}, new int[]{brownWeight, redWeight}));
        return super.finalizeSpawn(world, difficulty, reason, data);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(LivingThingsTags.SHROOMIE_FOOD);
    }

    public int getMaxSpawnClusterSize() {
        return ShroomieConfig.maxSpawnedInChunk();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.getVariant() == 1 && stack.is(Items.RED_MUSHROOM) || this.getVariant() == 0 && stack.is(Items.BROWN_MUSHROOM)) {
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            if (!this.hasMushroom) {
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                this.mushroomCooldown += 100;
                this.hasMushroom = true;
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.mobInteract(player, hand);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ShroomieConfig.health()).add(Attributes.MOVEMENT_SPEED, ShroomieConfig.movementSpeed());
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob parent) {
        ShroomieEntity shroomie = (ShroomieEntity)ModEntityTypes.SHROOMIE.get().create((Level)world);
        shroomie.setVariant(this.getVariantFromParents((AgeableMob)this, parent));
        shroomie.setAge(0);
        return shroomie;
    }

    public boolean canPlantMushroom() {
        return this.hasMushroom && this.mushroomCooldown <= 0;
    }

    public void plantedMushroom() {
        if (this.random.nextBoolean()) {
            this.hasMushroom = false;
        }
        this.mushroomCooldown = RANGED_INTEGER.sample(this.random);
    }

    @Override
    public byte getVariant() {
        return (Byte)this.entityData.get(VARIANT);
    }

    @Override
    public void setVariant(byte type) {
        if (type > 1 || type < 0) {
            return;
        }
        this.entityData.set(VARIANT, (Object)type);
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.SHROOMIE;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        byte variant = this.getVariant();
        if (variant == 1) {
            return LOOTTABLE_RED;
        }
        if (variant == 0) {
            return LOOTTABLE_BROWN;
        }
        return super.getDefaultLootTable();
    }

    private static ResourceKey<LootTable> createLootTableRK(String name) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"livingthings", (String)name));
    }
}

