/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.events;

import com.tristankechlo.livingthings.config.GeneralConfig;
import com.tristankechlo.livingthings.config.entity.AncientBlazeConfig;
import com.tristankechlo.livingthings.config.entity.BabyEnderDragonConfig;
import com.tristankechlo.livingthings.entity.AncientBlazeEntity;
import com.tristankechlo.livingthings.entity.BabyEnderDragonEntity;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class BlockEvents {
    public static void onBlockBreak(LevelAccessor world, Player player, BlockPos pos, BlockState state) {
        Registry registry;
        int silktouchLevel;
        if (!GeneralConfig.get().doBananaDrops.get().booleanValue()) {
            return;
        }
        if (world == null || state == null || player == null || pos == null) {
            return;
        }
        if (world.isClientSide() || player.isSpectator() || player.isCreative()) {
            return;
        }
        if (!state.is(LivingThingsTags.DROPS_BANANAS)) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (!stack.isEmpty() && ((silktouchLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)(registry = (Registry)world.registryAccess().registry(Registries.ENCHANTMENT).orElseThrow()).getHolderOrThrow(Enchantments.SILK_TOUCH), (ItemStack)stack)) > 0 || stack.getItem() instanceof ShearsItem)) {
            return;
        }
        double dropChance = (Double)GeneralConfig.get().bananaDropChance.get() / 100.0;
        if (world.getRandom().nextDouble() < dropChance) {
            ItemStack loot = new ItemStack((ItemLike)ModItems.BANANA.get());
            ItemEntity entity = new ItemEntity((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), loot);
            world.addFreshEntity((Entity)entity);
        }
    }

    public static InteractionResult onBlockPlace(LevelAccessor world, Player player, BlockPos pos, BlockState placedBlock) {
        if (world.isClientSide() || player.isSpectator()) {
            return InteractionResult.PASS;
        }
        if (!placedBlock.is(Blocks.JACK_O_LANTERN) && !placedBlock.is(Blocks.DRAGON_EGG)) {
            return InteractionResult.PASS;
        }
        BlockState blockBelow = world.getBlockState(pos.below());
        BlockState blockBelow2 = world.getBlockState(pos.below(2));
        if (placedBlock.is(Blocks.JACK_O_LANTERN) && blockBelow.is(Blocks.GLOWSTONE) && blockBelow2.is(Blocks.GLOWSTONE)) {
            if (!AncientBlazeConfig.canSpawn()) {
                return InteractionResult.PASS;
            }
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            world.setBlock(pos.below(), Blocks.AIR.defaultBlockState(), 3);
            world.setBlock(pos.below(2), Blocks.AIR.defaultBlockState(), 3);
            AncientBlazeEntity blaze = (AncientBlazeEntity)ModEntityTypes.ANCIENT_BLAZE.get().create((Level)world);
            blaze.setInvulnerableTime(AncientBlazeConfig.chargingTime());
            blaze.setPos((double)pos.getX() + 0.5, (double)pos.below(2).getY() + 0.2, (double)pos.getZ() + 0.5);
            world.addFreshEntity((Entity)blaze);
            return InteractionResult.SUCCESS;
        }
        if (placedBlock.is(Blocks.DRAGON_EGG) && blockBelow.is(Blocks.PURPUR_PILLAR) && blockBelow.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y) {
            if (world.dimensionType().hasCeiling()) {
                return InteractionResult.PASS;
            }
            if (!BabyEnderDragonConfig.canSpawn()) {
                return InteractionResult.PASS;
            }
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            int count = 10;
            double radius = 6.0;
            for (int i = 0; i < 10; ++i) {
                LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)world);
                double x = (double)pos.getX() + 6.0 * (double)Mth.cos((float)((float)(i * 2) * (float)Math.PI / 10.0f));
                double z = (double)pos.getZ() + 6.0 * (double)Mth.sin((float)((float)(i * 2) * (float)Math.PI / 10.0f));
                double y = pos.below().getY();
                bolt.setPos(x, y, z);
                world.addFreshEntity((Entity)bolt);
            }
            BabyEnderDragonEntity dragon = (BabyEnderDragonEntity)ModEntityTypes.BABY_ENDER_DRAGON.get().create((Level)world);
            dragon.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5);
            world.addFreshEntity((Entity)dragon);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

