/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.item;

import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.platform.IPlatformHelper;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class LexiconItem
extends Item {
    private static final String URL = "https://github.com/tristankechlo/Living-Things/wiki";
    private static final MutableComponent SUBTITLE = Component.literal((String)"2nd Edition").withStyle(ChatFormatting.GRAY);

    public LexiconItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)playerIn;
            if (IPlatformHelper.INSTANCE.isModLoaded("patchouli")) {
                ResourceLocation book = BuiltInRegistries.ITEM.getKey((Object)ModItems.LEXICON.get());
                IPlatformHelper.INSTANCE.openBookGui(player, book);
            } else {
                player.connection.send((Packet)new ClientboundSetTitleTextPacket((Component)Component.translatable((String)"messages.livingthings.nopatchouli.title")));
                player.connection.send((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.translatable((String)"messages.livingthings.nopatchouli.subtitle")));
                player.sendSystemMessage((Component)Component.translatable((String)"messages.livingthings.nopatchouli.wiki", (Object[])new Object[]{URL}));
            }
        }
        ItemStack stack = playerIn.getItemInHand(handIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        boolean patchouliLoaded = IPlatformHelper.INSTANCE.isModLoaded("patchouli");
        if (target.level().isClientSide() && patchouliLoaded && target instanceof ILexiconEntry) {
            ResourceLocation book = BuiltInRegistries.ITEM.getKey((Object)ModItems.LEXICON.get());
            ResourceLocation entry = ((ILexiconEntry)target).getLexiconEntry();
            IPlatformHelper.INSTANCE.openBookEntry(book, entry, 0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useOn(UseOnContext context) {
        Block block = context.getLevel().getBlockState(context.getClickedPos()).getBlock();
        boolean patchouliLoaded = IPlatformHelper.INSTANCE.isModLoaded("patchouli");
        if (context.getLevel().isClientSide() && patchouliLoaded && block instanceof ILexiconEntry) {
            ResourceLocation book = BuiltInRegistries.ITEM.getKey((Object)ModItems.LEXICON.get());
            ResourceLocation entry = ((ILexiconEntry)block).getLexiconEntry();
            IPlatformHelper.INSTANCE.openBookEntry(book, entry, 0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)SUBTITLE);
    }
}

