/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.loot.functions;

import com.github.jarva.arsadditions.common.item.data.ExplorationScrollData;
import com.github.jarva.arsadditions.server.util.LocateUtil;
import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonLootItemFunctionsRegistry;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class ExplorationScrollFunction
extends LootItemConditionalFunction {
    private final Optional<HolderSet<Structure>> destination;
    private final int searchRadius;
    private final boolean skipKnownStructures;
    public static final MapCodec<ExplorationScrollFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(func -> func.predicates), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE).optionalFieldOf("structure").forGetter(func -> func.destination), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("search_radius", (Object)50).forGetter(func -> func.searchRadius), (App)Codec.BOOL.optionalFieldOf("skip_existing_chunks", (Object)true).forGetter(func -> func.skipKnownStructures)).apply((Applicative)inst, ExplorationScrollFunction::new));

    protected ExplorationScrollFunction(List<LootItemCondition> predicates, Optional<HolderSet<Structure>> destination, int searchRadius, boolean skipKnownStructures) {
        super(predicates);
        this.destination = destination;
        this.searchRadius = searchRadius;
        this.skipKnownStructures = skipKnownStructures;
    }

    public LootItemFunctionType<ExplorationScrollFunction> getType() {
        return (LootItemFunctionType)AddonLootItemFunctionsRegistry.EXPLORATION_SCROLL_TYPE.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.ORIGIN);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        if (!stack.is((Item)AddonItemRegistry.EXPLORATION_WARP_SCROLL.get())) {
            return stack;
        }
        Vec3 origin = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        this.saveData(stack, origin);
        if (origin == null) {
            return stack;
        }
        ServerLevel level = context.getLevel();
        LocateUtil.locateWithState(stack, level, this.destination.orElse((HolderSet<Structure>)((Registry)context.getLevel().registryAccess().registry(Registries.STRUCTURE).orElseThrow()).getOrCreateTag(ExplorationScrollData.DEFAULT_DESTINATION)), BlockPos.containing((Position)origin), this.searchRadius, this.skipKnownStructures);
        return stack;
    }

    private void saveData(ItemStack stack, Vec3 origin) {
        stack.set(AddonDataComponentRegistry.EXPLORATION_SCROLL_DATA, (Object)new ExplorationScrollData(this.destination, Optional.ofNullable(origin), this.searchRadius, this.skipKnownStructures));
    }
}

