/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.registry;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.client.renderers.tile.WarpNexusRenderer;
import com.github.jarva.arsadditions.common.block.EnchantingWixieCauldron;
import com.github.jarva.arsadditions.common.block.EnderSourceJar;
import com.github.jarva.arsadditions.common.block.MagelightLantern;
import com.github.jarva.arsadditions.common.block.SourceSpawner;
import com.github.jarva.arsadditions.common.block.WarpNexus;
import com.github.jarva.arsadditions.common.block.tile.EnchantingWixieCauldronTile;
import com.github.jarva.arsadditions.common.block.tile.EnderSourceJarTile;
import com.github.jarva.arsadditions.common.block.tile.MagelightLanternTile;
import com.github.jarva.arsadditions.common.block.tile.SourceSpawnerTile;
import com.github.jarva.arsadditions.common.block.tile.WarpNexusTile;
import com.github.jarva.arsadditions.common.item.EnderSourceJarItem;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.names.AddonBlockNames;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericTileRenderer;
import com.hollingsworth.arsnouveau.common.items.RendererBlockItem;
import com.hollingsworth.arsnouveau.setup.registry.BlockEntityTypeRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistryWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AddonBlockRegistry {
    public static final List<BlockRegistryWrapper<? extends Block>> REGISTERED_BLOCKS = new ArrayList<BlockRegistryWrapper<? extends Block>>();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"ars_additions");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"ars_additions");
    public static BlockEntityTypeRegistryWrapper<MagelightLanternTile> MAGELIGHT_LANTERN_TILE;
    public static BlockRegistryWrapper<EnderSourceJar> ENDER_SOURCE_JAR;
    public static BlockEntityTypeRegistryWrapper<EnderSourceJarTile> ENDER_SOURCE_JAR_TILE;
    public static BlockRegistryWrapper<WarpNexus> WARP_NEXUS;
    public static BlockEntityTypeRegistryWrapper<WarpNexusTile> WARP_NEXUS_TILE;
    public static BlockRegistryWrapper<EnchantingWixieCauldron> WIXIE_ENCHANTING;
    public static BlockEntityTypeRegistryWrapper<EnchantingWixieCauldronTile> WIXIE_ENCHANTING_TILE;
    public static BlockRegistryWrapper<SourceSpawner> SOURCE_SPAWNER;
    public static BlockEntityTypeRegistryWrapper<SourceSpawnerTile> SOURCE_SPAWNER_TILE;

    private static void registerCarpets() {
        for (String carpet : AddonBlockNames.CARPETS) {
            AddonBlockRegistry.registerBlockAndItem(carpet, () -> new CarpetBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_CARPET)));
        }
    }

    private static void registerDecorativeSourcestone() {
        for (String sourcestone : AddonBlockNames.DECORATIVE_SOURCESTONES) {
            AddonBlockRegistry.registerBlockAndItem(sourcestone, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BlockRegistry.getBlock((String)"sourcestone"))));
        }
    }

    private static void registerTrapdoors() {
        for (String trapdoor : AddonBlockNames.TRAPDOORS) {
            AddonBlockRegistry.registerBlockAndItem(trapdoor, () -> new TrapDoorBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BlockRegistry.getBlock((String)"archwood_trapdoor"))));
        }
    }

    private static void registerDoors() {
        for (String door : AddonBlockNames.DOORS) {
            AddonBlockRegistry.registerBlockAndItem(door, () -> new DoorBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BlockRegistry.getBlock((String)"archwood_door"))));
        }
    }

    private static void registerChains() {
        for (String chain : AddonBlockNames.CHAINS) {
            AddonBlockRegistry.registerBlockAndItem(chain, () -> new ChainBlock(BlockBehaviour.Properties.of().forceSolidOn().requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.CHAIN).noOcclusion()));
        }
    }

    private static void registerMagelightLanterns() {
        for (String lantern : AddonBlockNames.MAGELIGHT_LANTERNS) {
            AddonBlockRegistry.registerBlockAndItem(lantern, MagelightLantern::new);
        }
    }

    private static void registerLanterns() {
        for (String lantern : AddonBlockNames.LANTERNS) {
            AddonBlockRegistry.registerBlockAndItem(lantern, () -> new LanternBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().requiresCorrectToolForDrops().strength(3.5f).sound(SoundType.LANTERN).lightLevel(arg -> 15).noOcclusion().pushReaction(PushReaction.DESTROY)));
        }
    }

    private static void registerWalls() {
        for (String wall : AddonBlockNames.WALLS) {
            AddonBlockRegistry.registerBlockAndItem(wall, () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BlockRegistry.getBlock((String)"sourcestone")).forceSolidOn()));
        }
    }

    private static void registerButtons() {
        for (String button : AddonBlockNames.BUTTONS) {
            AddonBlockRegistry.registerBlockAndItem(button, () -> new ButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.of().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY)));
        }
    }

    public static BlockItem getDefaultBlockItem(Block block) {
        return new BlockItem(block, AddonItemRegistry.defaultItemProperties());
    }

    public static <T extends Block> BlockRegistryWrapper<T> registerBlockAndItem(String name, Supplier<T> blockSupp) {
        return AddonBlockRegistry.registerBlockAndItem(name, blockSupp, block -> AddonBlockRegistry.getDefaultBlockItem((Block)block.get()));
    }

    public static <T extends Block, R extends BlockItem> BlockRegistryWrapper<T> registerBlockAndItem(String name, Supplier<T> blockSupp, Function<BlockRegistryWrapper<T>, R> itemSupp) {
        BlockRegistryWrapper block = new BlockRegistryWrapper(BLOCKS.register(name, blockSupp));
        REGISTERED_BLOCKS.add((BlockRegistryWrapper<? extends Block>)block);
        AddonItemRegistry.ITEMS.register(name, () -> (BlockItem)itemSupp.apply(block));
        return block;
    }

    public static <T extends BlockEntity> BlockEntityTypeRegistryWrapper<T> registerTile(String regName, BlockEntityType.BlockEntitySupplier<T> tile, Supplier<Block[]> block) {
        return new BlockEntityTypeRegistryWrapper(BLOCK_ENTITIES.register(regName, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)tile, (Block[])((Block[])block.get())).build(null)));
    }

    public static Block getBlock(String s) {
        return (Block)BuiltInRegistries.BLOCK.get(ArsAdditions.prefix(s));
    }

    public static Block[] getBlocks(String[] names) {
        return Arrays.stream(names).map(AddonBlockRegistry::getBlock).toList().toArray(new Block[0]);
    }

    static {
        WIXIE_ENCHANTING = AddonBlockRegistry.registerBlockAndItem("enchanting_wixie_cauldron", EnchantingWixieCauldron::new, block -> new RendererBlockItem((Block)block.get(), AddonItemRegistry.defaultItemProperties()){

            public Supplier<BlockEntityWithoutLevelRenderer> getRenderer() {
                return GenericTileRenderer.getISTER((String)"enchanting_apparatus");
            }
        });
        WIXIE_ENCHANTING_TILE = AddonBlockRegistry.registerTile("enchanting_wixie_cauldron", EnchantingWixieCauldronTile::new, () -> new Block[]{(Block)WIXIE_ENCHANTING.get()});
        ENDER_SOURCE_JAR = AddonBlockRegistry.registerBlockAndItem("ender_source_jar", EnderSourceJar::new, block -> new EnderSourceJarItem((Block)block.get(), AddonItemRegistry.defaultItemProperties()));
        ENDER_SOURCE_JAR_TILE = AddonBlockRegistry.registerTile("ender_source_jar", EnderSourceJarTile::new, () -> new Block[]{(Block)ENDER_SOURCE_JAR.get()});
        SOURCE_SPAWNER = AddonBlockRegistry.registerBlockAndItem("source_spawner", SourceSpawner::new);
        SOURCE_SPAWNER_TILE = AddonBlockRegistry.registerTile("source_spawner", SourceSpawnerTile::new, () -> new Block[]{(Block)SOURCE_SPAWNER.get()});
        WARP_NEXUS = AddonBlockRegistry.registerBlockAndItem("warp_nexus", WarpNexus::new, block -> new RendererBlockItem((Block)block.get(), AddonItemRegistry.defaultItemProperties()){

            public Supplier<BlockEntityWithoutLevelRenderer> getRenderer() {
                return WarpNexusRenderer::getISTER;
            }
        });
        WARP_NEXUS_TILE = AddonBlockRegistry.registerTile("warp_nexus", WarpNexusTile::new, () -> new Block[]{(Block)WARP_NEXUS.get()});
        AddonBlockRegistry.registerChains();
        AddonBlockRegistry.registerMagelightLanterns();
        AddonBlockRegistry.registerLanterns();
        MAGELIGHT_LANTERN_TILE = AddonBlockRegistry.registerTile("magelight_lantern", MagelightLanternTile::new, () -> AddonBlockRegistry.getBlocks(AddonBlockNames.MAGELIGHT_LANTERNS));
        AddonBlockRegistry.registerWalls();
        AddonBlockRegistry.registerButtons();
        AddonBlockRegistry.registerDecorativeSourcestone();
        AddonBlockRegistry.registerDoors();
        AddonBlockRegistry.registerTrapdoors();
        AddonBlockRegistry.registerCarpets();
    }
}

