/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.recipe.stack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public abstract class IngredientStack<T, S extends Predicate<T>> {
    protected final S ingredient;
    protected int amount;
    public static final Codec<Item> ITEM_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(i -> (Ingredient)i.ingredient), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("amount", (Object)1).forGetter(i -> i.amount)).apply((Applicative)builder, Item::new));
    public static final Codec<Fluid> FLUID_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)FluidIngredient.CODEC.fieldOf("ingredient").forGetter(i -> (FluidIngredient)i.ingredient), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("amount", (Object)1).forGetter(i -> i.amount)).apply((Applicative)builder, Fluid::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Item> ITEM_STREAM_CODEC = StreamCodec.of((buf, s) -> s.to((RegistryFriendlyByteBuf)buf), IngredientStack::ofItem);
    public static final StreamCodec<RegistryFriendlyByteBuf, Fluid> FLUID_STREAM_CODEC = StreamCodec.of((buf, s) -> s.to((RegistryFriendlyByteBuf)buf), IngredientStack::ofFluid);

    public IngredientStack(S ingredient, int amount) {
        this.ingredient = ingredient;
        this.amount = amount;
    }

    public S getIngredient() {
        return this.ingredient;
    }

    public int getAmount() {
        return this.amount;
    }

    public static Item of(ItemStack ingredient) {
        return new Item(Ingredient.of((ItemStack[])new ItemStack[]{ingredient}), ingredient.getCount());
    }

    public static Item of(Ingredient ingredient, int amount) {
        return new Item(ingredient, amount);
    }

    public static Fluid of(FluidStack ingredient) {
        return new Fluid(FluidIngredient.of((FluidStack[])new FluidStack[]{ingredient}), ingredient.getAmount());
    }

    public static Fluid of(FluidIngredient ingredient, int amount) {
        return new Fluid(ingredient, amount);
    }

    public static Item ofItem(RegistryFriendlyByteBuf buff) {
        return new Item((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buff), buff.readInt());
    }

    public static Fluid ofFluid(RegistryFriendlyByteBuf buff) {
        return new Fluid((FluidIngredient)FluidIngredient.STREAM_CODEC.decode((Object)buff), buff.readInt());
    }

    public abstract void to(RegistryFriendlyByteBuf var1);

    public void consume(Object stack) {
        if (this.amount <= 0) {
            return;
        }
        if (this.ingredient.test((Object)stack)) {
            int from = this.getStackAmount(stack);
            if (from > this.amount) {
                this.setStackAmount(stack, from - this.amount);
                this.amount = 0;
            } else {
                this.setStackAmount(stack, 0);
                this.amount -= from;
            }
        }
    }

    public boolean isEmpty() {
        return this.amount <= 0;
    }

    public abstract boolean checkType(Object var1);

    public abstract IngredientStack<T, S> sample();

    public abstract int getStackAmount(T var1);

    public abstract void setStackAmount(T var1, int var2);

    public String toString() {
        return this.amount + "x" + String.valueOf(this.ingredient);
    }

    public static final class Item
    extends IngredientStack<ItemStack, Ingredient> {
        public static final Item EMPTY = new Item(Ingredient.EMPTY, 0);

        private Item(Ingredient ingredient, int amount) {
            super(ingredient, amount);
        }

        @Override
        public void to(RegistryFriendlyByteBuf buff) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buff, (Object)((Ingredient)this.ingredient));
            buff.writeInt(this.amount);
        }

        @Override
        public boolean checkType(Object obj) {
            return obj instanceof ItemStack;
        }

        public Item sample() {
            return new Item((Ingredient)this.ingredient, this.amount);
        }

        @Override
        public int getStackAmount(ItemStack stack) {
            return stack.getCount();
        }

        @Override
        public void setStackAmount(ItemStack stack, int amount) {
            stack.setCount(amount);
        }
    }

    public static final class Fluid
    extends IngredientStack<FluidStack, FluidIngredient> {
        public static final Fluid EMPTY = new Fluid(FluidIngredient.empty(), 0);

        private Fluid(FluidIngredient ingredient, int amount) {
            super(ingredient, amount);
        }

        @Override
        public void to(RegistryFriendlyByteBuf buff) {
            FluidIngredient.STREAM_CODEC.encode((Object)buff, (Object)((FluidIngredient)this.ingredient));
            buff.writeInt(this.amount);
        }

        @Override
        public boolean checkType(Object obj) {
            return obj instanceof FluidStack;
        }

        public Fluid sample() {
            return new Fluid((FluidIngredient)this.ingredient, this.amount);
        }

        @Override
        public int getStackAmount(FluidStack stack) {
            return stack.getAmount();
        }

        @Override
        public void setStackAmount(FluidStack stack, int amount) {
            stack.setAmount(amount);
        }
    }
}

