/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageWidget;
import com.hollingsworth.arsnouveau.api.documentation.export.DocExporter;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PerkDiagramEntry
extends SinglePageWidget {
    public ItemStack item1;
    public ItemStack item2;
    public ItemStack item3;
    public ItemStack item4;

    public PerkDiagramEntry(BaseDocScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
    }

    public static SinglePageCtor create(ItemLike item1, ItemLike item2, ItemLike item3, ItemLike item4) {
        return (parent, x, y, width, height) -> {
            PerkDiagramEntry entry = new PerkDiagramEntry(parent, x, y, width, height);
            entry.item1 = item1.asItem().getDefaultInstance();
            entry.item2 = item2.asItem().getDefaultInstance();
            entry.item3 = item3.asItem().getDefaultInstance();
            entry.item4 = item4.asItem().getDefaultInstance();
            return entry;
        };
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        DocClientUtils.drawHeader((Component)Component.translatable((String)"ars_nouveau.slots_armor"), guiGraphics, this.x, this.y, this.width, mouseX, mouseY, partialTick);
        int xOffset = 10;
        DocClientUtils.blit(guiGraphics, DocAssets.THREAD_FRAME, this.x + xOffset, this.y + 19);
        int fontYOffset = 111;
        int fontXOffset = xOffset + 21;
        DocClientUtils.drawParagraph((Component)Component.literal((String)"Tier of armor"), guiGraphics, this.x + fontXOffset, this.y + fontYOffset, this.width - 2, mouseX, mouseY, partialTick);
        DocClientUtils.drawParagraph((Component)Component.translatable((String)"ars_nouveau.thread_tier", (Object[])new Object[]{1}), guiGraphics, this.x + fontXOffset, this.y + fontYOffset + 10, this.width - 2, mouseX, mouseY, partialTick);
        DocClientUtils.drawParagraph((Component)Component.translatable((String)"ars_nouveau.thread_tier", (Object[])new Object[]{2}), guiGraphics, this.x + fontXOffset, this.y + fontYOffset + 20, this.width - 2, mouseX, mouseY, partialTick);
        DocClientUtils.drawParagraph((Component)Component.translatable((String)"ars_nouveau.thread_tier", (Object[])new Object[]{3}), guiGraphics, this.x + fontXOffset, this.y + fontYOffset + 30, this.width - 2, mouseX, mouseY, partialTick);
        int itemYOffset = 30;
        this.setTooltipIfHovered(DocClientUtils.renderItemStack(guiGraphics, this.x + xOffset + 2, this.y + itemYOffset, mouseX, mouseY, this.item1));
        this.setTooltipIfHovered(DocClientUtils.renderItemStack(guiGraphics, this.x + xOffset + 2, this.y + itemYOffset + 19, mouseX, mouseY, this.item2));
        this.setTooltipIfHovered(DocClientUtils.renderItemStack(guiGraphics, this.x + xOffset + 2, this.y + itemYOffset + 38, mouseX, mouseY, this.item3));
        this.setTooltipIfHovered(DocClientUtils.renderItemStack(guiGraphics, this.x + xOffset + 2, this.y + itemYOffset + 57, mouseX, mouseY, this.item4));
        int perkXOffset = 35;
        int perkYOffset = 35;
        this.drawRow(guiGraphics, this.x + perkXOffset, this.y + perkYOffset, this.item1);
        this.drawRow(guiGraphics, this.x + perkXOffset, this.y + perkYOffset + 19, this.item2);
        this.drawRow(guiGraphics, this.x + perkXOffset, this.y + perkYOffset + 38, this.item3);
        this.drawRow(guiGraphics, this.x + perkXOffset, this.y + perkYOffset + 57, this.item4);
    }

    public void drawRow(GuiGraphics graphics, int x, int y, ItemStack stack) {
        List<List<PerkSlot>> provider = PerkRegistry.getPerkProvider(stack);
        if (provider != null) {
            for (int tier = 0; tier < provider.size(); ++tier) {
                List<PerkSlot> levelOne = provider.get(tier);
                int extraOffset = switch (tier) {
                    case 0 -> 0;
                    case 1 -> 6;
                    case 2 -> 20;
                    default -> 0;
                };
                this.drawSlotList(graphics, x + tier * 12 + extraOffset, y, levelOne);
            }
        }
    }

    public void drawSlotList(GuiGraphics graphics, int x, int y, List<PerkSlot> perks) {
        for (int i = 0; i < perks.size(); ++i) {
            PerkSlot perk = perks.get(i);
            DocClientUtils.blit(graphics, perk.icon(), x + i * 8, y);
        }
    }

    @Override
    public void addExportProperties(JsonObject object) {
        JsonArray perkData;
        super.addExportProperties(object);
        if (this.item1 != null) {
            perkData = this.getPerkRowExport(this.item1);
            JsonObject item1Data = new JsonObject();
            item1Data.addProperty(DocExporter.ITEM_PROPERTY, BuiltInRegistries.ITEM.getKey((Object)this.item1.getItem()).toString());
            item1Data.add(DocExporter.PERKS_PROPERTY, (JsonElement)perkData);
            object.add("item1", (JsonElement)item1Data);
        }
        if (this.item2 != null) {
            perkData = this.getPerkRowExport(this.item2);
            JsonObject item2Data = new JsonObject();
            item2Data.addProperty(DocExporter.ITEM_PROPERTY, BuiltInRegistries.ITEM.getKey((Object)this.item2.getItem()).toString());
            item2Data.add(DocExporter.PERKS_PROPERTY, (JsonElement)perkData);
            object.add("item2", (JsonElement)item2Data);
        }
        if (this.item3 != null) {
            perkData = this.getPerkRowExport(this.item3);
            JsonObject item3Data = new JsonObject();
            item3Data.addProperty(DocExporter.ITEM_PROPERTY, BuiltInRegistries.ITEM.getKey((Object)this.item3.getItem()).toString());
            item3Data.add(DocExporter.PERKS_PROPERTY, (JsonElement)perkData);
            object.add("item3", (JsonElement)item3Data);
        }
        if (this.item4 != null) {
            perkData = this.getPerkRowExport(this.item4);
            JsonObject item4Data = new JsonObject();
            item4Data.addProperty(DocExporter.ITEM_PROPERTY, BuiltInRegistries.ITEM.getKey((Object)this.item4.getItem()).toString());
            item4Data.add(DocExporter.PERKS_PROPERTY, (JsonElement)perkData);
            object.add("item4", (JsonElement)item4Data);
        }
    }

    public JsonArray getPerkRowExport(ItemStack stack) {
        List<List<PerkSlot>> provider = PerkRegistry.getPerkProvider(stack);
        JsonArray tiersData = new JsonArray();
        if (provider != null) {
            for (int tier = 0; tier < provider.size(); ++tier) {
                JsonObject tierData = new JsonObject();
                tierData.addProperty("tier", (Number)tier);
                JsonArray perkSlots = new JsonArray();
                for (PerkSlot slot : provider.get(tier)) {
                    perkSlots.add((Number)slot.value());
                }
                tierData.add("perks", (JsonElement)perkSlots);
                tiersData.add((JsonElement)tierData);
            }
        }
        return tiersData;
    }
}

