/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations.properties;

import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class PropMap {
    public static final Codec<Map<IPropertyType<?>, Object>> VALUE_MAP_CODEC = Codec.dispatchedMap(ParticlePropertyRegistry.CODEC, IPropertyType::normalCodec);
    public static Codec<PropMap> CODEC = PropMap.makeCodecFromMap(VALUE_MAP_CODEC);
    public static StreamCodec<RegistryFriendlyByteBuf, PropMap> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, PropMap>(){

        public PropMap decode(RegistryFriendlyByteBuf buffer) {
            int i = buffer.readVarInt();
            Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(Math.min(i, 65536));
            for (int l = 0; l < i; ++l) {
                IPropertyType datacomponenttype = (IPropertyType)IPropertyType.STREAM_CODEC.decode((Object)buffer);
                Object object = datacomponenttype.streamCodec().decode((Object)buffer);
                reference2objectmap.put((Object)datacomponenttype, object);
            }
            return new PropMap((Map<IPropertyType<?>, Object>)reference2objectmap);
        }

        public void encode(RegistryFriendlyByteBuf buffer, PropMap value) {
            int i = value.properties.size();
            buffer.writeVarInt(i);
            for (Reference2ObjectMap.Entry entry1 : Reference2ObjectMaps.fastIterable(value.properties)) {
                Object optional = entry1.getValue();
                IPropertyType datacomponenttype = (IPropertyType)entry1.getKey();
                IPropertyType.STREAM_CODEC.encode((Object)buffer, (Object)datacomponenttype);
                1.encodeComponent(buffer, datacomponenttype, optional);
            }
        }

        private static <T extends BaseProperty> void encodeComponent(RegistryFriendlyByteBuf buffer, IPropertyType<T> component, Object value) {
            component.streamCodec().encode((Object)buffer, (Object)((BaseProperty)value));
        }
    };
    private Reference2ObjectOpenHashMap<IPropertyType<?>, Object> properties;

    private static Codec<PropMap> makeCodecFromMap(Codec<Map<IPropertyType<?>, Object>> codec) {
        return codec.flatComapMap(PropMap::new, p_337448_ -> {
            int i = p_337448_.properties.size();
            Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(i);
            reference2objectmap.putAll(p_337448_.properties);
            return DataResult.success((Object)reference2objectmap);
        });
    }

    public PropMap() {
        this.properties = new Reference2ObjectOpenHashMap();
    }

    public PropMap(Map<IPropertyType<?>, Object> map) {
        this.properties = new Reference2ObjectOpenHashMap(map);
    }

    public <T extends BaseProperty> T get(IPropertyType<T> type) {
        return (T)((BaseProperty)this.properties.get(type));
    }

    public <T extends BaseProperty> T get(Supplier<IPropertyType<T>> type) {
        return this.get(type.get());
    }

    public <T extends BaseProperty> Optional<T> getOptional(IPropertyType<T> type) {
        return Optional.ofNullable((BaseProperty)this.properties.get(type));
    }

    public boolean has(IPropertyType<?> type) {
        return this.properties.containsKey(type);
    }

    public <T extends BaseProperty> T getOrDefault(IPropertyType<T> type, T defaultValue) {
        return (T)((BaseProperty)this.properties.getOrDefault(type, defaultValue));
    }

    public <T extends BaseProperty> void set(IPropertyType<T> type, T value) {
        this.properties.put(type, value);
    }

    public <T extends BaseProperty> T getOrCreate(IPropertyType<T> type, Supplier<T> defaultValueSupplier) {
        return (T)((BaseProperty)this.properties.computeIfAbsent(type, k -> defaultValueSupplier.get()));
    }

    public <T extends BaseProperty> T createIfMissing(T defaultValue) {
        return (T)((BaseProperty)this.properties.computeIfAbsent(defaultValue.getType(), k -> defaultValue));
    }

    public void removePropsOnMotionChange() {
        HashSet<PropMap> visitedMaps = new HashSet<PropMap>();
        this.removePropsOnMotionChange(visitedMaps);
    }

    public void removePropsOnMotionChange(Set<PropMap> visitedMaps) {
        this.properties.entrySet().removeIf(entry -> {
            BaseProperty property = (BaseProperty)entry.getValue();
            if (!visitedMaps.contains(property.propertyHolder)) {
                visitedMaps.add(property.propertyHolder);
                property.propertyHolder.removePropsOnMotionChange(visitedMaps);
            }
            return !property.survivesMotionChange();
        });
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropMap propMap = (PropMap)o;
        return Objects.equals(this.properties, propMap.properties);
    }

    public int hashCode() {
        return Objects.hashCode(this.properties);
    }
}

