/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.MathUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;

public class SpellUtil {
    public static SpellCastEvent postEvent(SpellCastEvent e) {
        return (SpellCastEvent)NeoForge.EVENT_BUS.post((Event)e);
    }

    public static List<BlockPos> calcAOEBlocks(LivingEntity caster, BlockPos origin, BlockHitResult mop, int aoeBonus) {
        return SpellUtil.calcAOEBlocks(caster, origin, mop, 1 + aoeBonus, 1 + aoeBonus, 1, -1);
    }

    public static List<BlockPos> calcAOEBlocks(LivingEntity caster, BlockPos origin, BlockHitResult mop, double aoeBonus) {
        return SpellUtil.calcAOEBlocks(caster, origin, mop, (int)(1.0 + Math.floor(aoeBonus)), (int)(1.0 + Math.ceil(aoeBonus)), 1, -1);
    }

    public static List<BlockPos> calcAOEBlocks(LivingEntity caster, BlockPos origin, BlockHitResult mop, SpellStats stats) {
        double aoeBonus = stats.getAoeMultiplier();
        int pierceBonus = stats.getBuffCount(AugmentPierce.INSTANCE);
        return SpellUtil.calcAOEBlocks(caster, origin, mop, aoeBonus, pierceBonus);
    }

    public static boolean isCorrectHarvestLevel(int strength, BlockState state) {
        Tiers tier;
        switch (strength) {
            case 2: {
                Tiers tiers = Tiers.STONE;
                break;
            }
            case 3: {
                Tiers tiers = Tiers.IRON;
                break;
            }
            case 4: {
                Tiers tiers = Tiers.DIAMOND;
                break;
            }
            case 5: {
                Tiers tiers = Tiers.NETHERITE;
                break;
            }
            default: {
                Tiers tiers = tier = Tiers.WOOD;
            }
        }
        if (strength > 5) {
            tier = Tiers.NETHERITE;
        }
        return !BuiltInRegistries.BLOCK.getOrCreateTag(tier.getIncorrectBlocksForDrops()).contains(state.getBlockHolder());
    }

    public static List<BlockPos> calcAOEBlocks(LivingEntity caster, BlockPos origin, BlockHitResult mop, int aoeBonus, int pierceBonus) {
        return SpellUtil.calcAOEBlocks(caster, origin, mop, 1 + aoeBonus, 1 + aoeBonus, 1 + pierceBonus, -1);
    }

    public static List<BlockPos> calcAOEBlocks(LivingEntity caster, BlockPos origin, BlockHitResult mop, double aoeBonus, int pierceBonus) {
        return SpellUtil.calcAOEBlocks(caster, origin, mop, (int)(1.0 + Math.floor(aoeBonus)), (int)(1.0 + Math.ceil(aoeBonus)), 1 + pierceBonus, -1);
    }

    public static List<BlockPos> calcAOEBlocks(LivingEntity caster, BlockPos origin, BlockHitResult mop, int width, int height, int depth, int distance) {
        Vec3i hitVec = caster.getDirection().getNormal();
        if (caster instanceof FakePlayer) {
            mop = new BlockHitResult(mop.getLocation(), mop.getDirection(), mop.getBlockPos(), false);
        }
        return SpellUtil.calcAOEBlocks(hitVec, origin, mop, width, height, depth, distance);
    }

    public static List<BlockPos> calcAOEBlocks(Vec3 hitVec, BlockPos origin, BlockHitResult mop, int width, int height, int depth, int distance) {
        return SpellUtil.calcAOEBlocks(Direction.getNearest((double)hitVec.x, (double)hitVec.y, (double)hitVec.z).getOpposite().getNormal(), origin, mop, width, height, depth, distance);
    }

    public static List<BlockPos> calcAOEBlocks(Vec3i facingVec, BlockPos origin, BlockHitResult mop, int width, int height, int depth, int distance) {
        int z;
        int y;
        int x;
        BlockPos start = origin;
        switch (mop.isInside() ? Direction.DOWN : mop.getDirection()) {
            case DOWN: 
            case UP: {
                x = facingVec.getX() * height + facingVec.getZ() * width;
                y = mop.getDirection().getAxisDirection().getStep() * -depth;
                z = facingVec.getX() * width + facingVec.getZ() * height;
                start = start.offset(-x / 2, 0, -z / 2);
                if (x % 2 == 0) {
                    if (x > 0 && mop.getLocation().x - (double)mop.getBlockPos().getX() > 0.5) {
                        start = start.offset(1, 0, 0);
                    } else if (x < 0 && mop.getLocation().x - (double)mop.getBlockPos().getX() < 0.5) {
                        start = start.offset(-1, 0, 0);
                    }
                }
                if (z % 2 != 0) break;
                if (z > 0 && mop.getLocation().z - (double)mop.getBlockPos().getZ() > 0.5) {
                    start = start.offset(0, 0, 1);
                    break;
                }
                if (z >= 0 || !(mop.getLocation().z - (double)mop.getBlockPos().getZ() < 0.5)) break;
                start = start.offset(0, 0, -1);
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = width;
                y = height;
                z = mop.getDirection().getAxisDirection().getStep() * -depth;
                start = start.offset(-x / 2, -y / 2, 0);
                if (x % 2 == 0 && mop.getLocation().x - (double)mop.getBlockPos().getX() > 0.5) {
                    start = start.offset(1, 0, 0);
                }
                if (y % 2 != 0 || !(mop.getLocation().y - (double)mop.getBlockPos().getY() > 0.5)) break;
                start = start.offset(0, 1, 0);
                break;
            }
            case WEST: 
            case EAST: {
                x = mop.getDirection().getAxisDirection().getStep() * -depth;
                y = height;
                z = width;
                start = start.offset(0, -y / 2, -z / 2);
                if (y % 2 == 0 && mop.getLocation().y - (double)mop.getBlockPos().getY() > 0.5) {
                    start = start.offset(0, 1, 0);
                }
                if (z % 2 != 0 || !(mop.getLocation().z - (double)mop.getBlockPos().getZ() > 0.5)) break;
                start = start.offset(0, 0, 1);
                break;
            }
            default: {
                z = 0;
                y = 0;
                x = 0;
            }
        }
        ArrayList<BlockPos> builder = new ArrayList<BlockPos>();
        for (int xp = start.getX(); xp != start.getX() + x; xp += x / Mth.abs((int)x)) {
            for (int yp = start.getY(); yp != start.getY() + y; yp += y / Mth.abs((int)y)) {
                for (int zp = start.getZ(); zp != start.getZ() + z; zp += z / Mth.abs((int)z)) {
                    if (xp == origin.getX() && yp == origin.getY() && zp == origin.getZ() || distance > 0 && Mth.abs((int)(xp - origin.getX())) + Mth.abs((int)(yp - origin.getY())) + Mth.abs((int)(zp - origin.getZ())) > distance) continue;
                    BlockPos pos = new BlockPos(xp, yp, zp);
                    builder.add(pos);
                }
            }
        }
        builder.add(origin);
        return builder;
    }

    public static Set<BlockPos> DFSBlockstates(Level world, BlockPos start, int maxBlocks, Predicate<BlockState> isMatch) {
        return SpellUtil.DFSBlockstates(world, Collections.singleton(start), maxBlocks, isMatch);
    }

    private static Set<BlockPos> DFSBlockstates(Level world, Collection<BlockPos> start, int maxBlocks, Predicate<BlockState> isMatch) {
        LinkedList<BlockPos> searchQueue = new LinkedList<BlockPos>(start);
        HashSet<BlockPos> searched = new HashSet<BlockPos>(start);
        HashSet<BlockPos> found = new HashSet<BlockPos>();
        while (!searchQueue.isEmpty() && found.size() < maxBlocks) {
            BlockPos current = searchQueue.removeFirst();
            BlockState state = world.getBlockState(current);
            if (!isMatch.test(state)) continue;
            found.add(current);
            BlockPos.betweenClosedStream((BlockPos)current.offset(1, 1, 1), (BlockPos)current.offset(-1, -1, -1)).forEach(neighborMutable -> {
                if (searched.contains(neighborMutable)) {
                    return;
                }
                BlockPos neighbor = neighborMutable.immutable();
                searched.add(neighbor);
                searchQueue.add(neighbor);
            });
        }
        return found;
    }

    public static HitResult rayTrace(Entity entity, double length, float lookOffset, boolean hitLiquids) {
        HitResult result = entity.pick(length, lookOffset, hitLiquids);
        EntityHitResult entityLookedAt = MathUtil.getLookedAtEntity(entity, 25);
        return entityLookedAt == null ? result : entityLookedAt;
    }
}

