/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

@EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class SkyTextureHandler {
    @SubscribeEvent
    public static void renderSky(RenderLevelStageEvent event) {
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SKY)) {
            if (ArsNouveau.optifineLoaded || ((Boolean)Config.DISABLE_SKY_SHADER.get()).booleanValue()) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            if (ClientInfo.skyRenderTarget == null) {
                Window window = minecraft.getWindow();
                SkyTextureHandler.setupRenderTarget(window.getWidth(), window.getHeight());
            }
            PoseStack poseStack = event.getPoseStack();
            GameRenderer gameRenderer = minecraft.gameRenderer;
            LevelRenderer levelRenderer = minecraft.levelRenderer;
            Camera camera = gameRenderer.getMainCamera();
            Vec3 cameraPosition = camera.getPosition();
            Matrix4f projectionMatrix = event.getProjectionMatrix();
            float partialTick = event.getPartialTick().getGameTimeDeltaTicks();
            boolean isFoggy = minecraft.level.effects().isFoggyAt(Mth.floor((double)cameraPosition.x), Mth.floor((double)cameraPosition.y)) || minecraft.gui.getBossOverlay().shouldCreateWorldFog();
            ClientInfo.skyRenderTarget.bindWrite(true);
            RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
            FogRenderer.setupColor((Camera)camera, (float)partialTick, (ClientLevel)minecraft.level, (int)minecraft.options.getEffectiveRenderDistance(), (float)gameRenderer.getDarkenWorldAmount(partialTick));
            FogRenderer.levelFogColor();
            RenderSystem.setShader(GameRenderer::getPositionShader);
            levelRenderer.renderSky(event.getModelViewMatrix(), projectionMatrix, partialTick, camera, isFoggy, () -> FogRenderer.setupFog((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_SKY, (float)gameRenderer.getRenderDistance(), (boolean)isFoggy, (float)partialTick));
            Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.pushMatrix();
            modelViewStack.mul((Matrix4fc)poseStack.last().pose());
            RenderSystem.applyModelViewMatrix();
            if (minecraft.options.getCloudsType() != CloudStatus.OFF) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                levelRenderer.renderClouds(poseStack, event.getModelViewMatrix(), projectionMatrix, partialTick, cameraPosition.x, cameraPosition.y, cameraPosition.z);
            }
            RenderSystem.depthMask((boolean)false);
            levelRenderer.renderSnowAndRain(gameRenderer.lightTexture(), partialTick, cameraPosition.x, cameraPosition.y, cameraPosition.z);
            RenderSystem.depthMask((boolean)true);
            modelViewStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
            minecraft.getMainRenderTarget().bindWrite(true);
        }
    }

    public static void setupRenderTarget(int width, int height) {
        if (ClientInfo.skyRenderTarget != null) {
            ClientInfo.skyRenderTarget.destroyBuffers();
        }
        ClientInfo.skyRenderTarget = new TextureTarget(width, height, true, Minecraft.ON_OSX);
    }
}

