/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.emi;

import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.client.emi.EmiArsNouveauPlugin;
import com.hollingsworth.arsnouveau.client.emi.EmiEnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.client.emi.EmiMultiInputRecipe;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ArmorUpgradeRecipe;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class EmiArmorUpgradeRecipe
extends EmiEnchantingApparatusRecipe<ArmorUpgradeRecipe> {
    protected Upgrades upgradableCache = null;

    public EmiArmorUpgradeRecipe(ResourceLocation id, ArmorUpgradeRecipe recipe) {
        super(id, recipe);
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return EmiArsNouveauPlugin.ARMOR_UPGRADE_CATEGORY;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        this.reset();
        double angleBetweenEach = 360.0 / (double)((ArmorUpgradeRecipe)this.recipe).pedestalItems().size();
        EmiMultiInputRecipe.MultiProvider provider = this.multiProvider;
        Upgrades upgradable = this.getUpgradable();
        List<EmiStack> emiInputs = upgradable.from;
        List<EmiStack> emiOutputs = upgradable.to;
        widgets.addSlot(EmiIngredient.of(emiInputs), (int)this.center.x, (int)this.center.y);
        widgets.addSlot(EmiIngredient.of(emiOutputs), 100, 3).recipeContext((EmiRecipe)this);
        for (EmiIngredient input : provider.getEmiInputs()) {
            widgets.addSlot(input, (int)this.point.x, (int)this.point.y);
            this.point = EmiArmorUpgradeRecipe.rotatePointAbout(this.point, this.center, angleBetweenEach);
        }
        widgets.addText((Component)Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{1 + ((ArmorUpgradeRecipe)this.recipe).tier}), 0, 0, 10, false);
        this.addSourceWidget(widgets);
    }

    @Override
    protected List<EmiIngredient> generateInputs() {
        List<EmiIngredient> inputs = super.generateInputs();
        if (!inputs.isEmpty()) {
            inputs.set(0, EmiIngredient.of(this.getUpgradable().from));
        }
        return inputs;
    }

    private Upgrades getUpgradable() {
        if (this.upgradableCache != null) {
            return this.upgradableCache;
        }
        ArrayList<EmiStack> fromList = new ArrayList<EmiStack>();
        ArrayList<EmiStack> toList = new ArrayList<EmiStack>();
        List<ItemStack> stacks = PerkRegistry.getPerkProviderItems().stream().filter(item -> {
            AnimatedMagicArmor ama;
            return item instanceof AnimatedMagicArmor && (ama = (AnimatedMagicArmor)item).getMinTier() < ((ArmorUpgradeRecipe)this.recipe).tier;
        }).map(Item::getDefaultInstance).toList();
        for (ItemStack from : stacks) {
            ItemStack to = from.copy();
            List<List<PerkSlot>> perkProvider = PerkRegistry.getPerkProvider(from);
            if (perkProvider != null) {
                ArmorPerkHolder perkHolder = (ArmorPerkHolder)from.getOrDefault(DataComponentRegistry.ARMOR_PERKS, (Object)new ArmorPerkHolder(null, List.of(), 0, new HashMap<IPerk, CompoundTag>()));
                from.set(DataComponentRegistry.ARMOR_PERKS, (Object)perkHolder.setTier(((ArmorUpgradeRecipe)this.recipe).tier - 1));
                ArmorPerkHolder copyHolder = (ArmorPerkHolder)to.getOrDefault(DataComponentRegistry.ARMOR_PERKS, (Object)new ArmorPerkHolder(null, List.of(), 0, new HashMap<IPerk, CompoundTag>()));
                to.set(DataComponentRegistry.ARMOR_PERKS, (Object)copyHolder.setTier(((ArmorUpgradeRecipe)this.recipe).tier));
            }
            fromList.add(EmiStack.of((ItemStack)from));
            toList.add(EmiStack.of((ItemStack)to));
        }
        this.upgradableCache = new Upgrades(fromList, toList);
        return this.upgradableCache;
    }

    protected record Upgrades(List<EmiStack> from, List<EmiStack> to) {
    }
}

