/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;

public class HorizontalSlider
extends ExtendedSlider {
    Consumer<Double> onValueChange;
    DocAssets.BlitInfo sliderAsset;
    DocAssets.BlitInfo knobAsset;

    public HorizontalSlider(int x, int y, DocAssets.BlitInfo sliderAsset, DocAssets.BlitInfo knobAsset, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString) {
        super(x, y, sliderAsset.width(), knobAsset.height(), prefix, suffix, minValue, maxValue, currentValue, stepSize, precision, drawString);
        this.sliderAsset = sliderAsset;
        this.knobAsset = knobAsset;
    }

    public HorizontalSlider(int x, int y, DocAssets.BlitInfo sliderAsset, DocAssets.BlitInfo knobAsset, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString, Consumer<Double> onValueChange) {
        super(x, y, sliderAsset.width(), knobAsset.height(), prefix, suffix, minValue, maxValue, currentValue, stepSize, precision, drawString);
        this.onValueChange = onValueChange;
        this.sliderAsset = sliderAsset;
        this.knobAsset = knobAsset;
    }

    public HorizontalSlider(int x, int y, DocAssets.BlitInfo sliderAsset, DocAssets.BlitInfo knobAsset, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, boolean drawString, Consumer<Double> onValueChange) {
        super(x, y, sliderAsset.width(), knobAsset.height(), prefix, suffix, minValue, maxValue, currentValue, drawString);
        this.onValueChange = onValueChange;
        this.sliderAsset = sliderAsset;
        this.knobAsset = knobAsset;
    }

    protected void applyValue() {
        if (this.onValueChange != null) {
            this.onValueChange.accept(this.value);
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        DocClientUtils.blit(guiGraphics, this.sliderAsset, this.x, this.y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DocClientUtils.blit(guiGraphics, this.knobAsset, this.x + (int)(this.value * (double)(this.width - this.knobAsset.width())), this.y - 1);
        int j = 0xA0A0A0;
        if (this.drawString) {
            guiGraphics.drawString(font, this.getMessage(), this.x + this.width / 4, this.y + (this.height - 32) / 2, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24, false);
        }
    }
}

