/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.items.data.ItemScrollData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class ItemDetectorTile
extends ModdedTile
implements ITickable,
IWandable,
ITooltipProvider {
    public BlockPos connectedPos;
    public boolean isPowered;
    public int neededCount;
    public ItemStack filterStack = ItemStack.EMPTY;
    public boolean inverted;

    public ItemDetectorTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public ItemDetectorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.ITEM_DETECTOR_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        if (this.level.isClientSide || this.connectedPos == null || this.level.getGameTime() % 20L != 0L) {
            return;
        }
        BlockEntity tile = this.level.getBlockEntity(this.connectedPos);
        if (tile == null) {
            return;
        }
        IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.connectedPos, null);
        if (handler == null) {
            return;
        }
        int found = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack ghostStack = handler.getStackInSlot(i);
            ItemStack extractedStack = handler.extractItem(i, ghostStack.getCount(), true);
            found = ghostStack.getCount() > extractedStack.getCount() && extractedStack.getMaxStackSize() == extractedStack.getCount() ? (found += this.getCountForStack(ghostStack)) : (found += this.getCountForStack(extractedStack));
            if (found <= this.neededCount) continue;
            this.setReachedCount(true);
            return;
        }
        this.setReachedCount(false);
    }

    public int getCountForStack(ItemStack stack) {
        ItemScroll scroll;
        ItemScroll.SortPref pref;
        Item item = this.filterStack.getItem();
        if (item instanceof ItemScroll && (pref = (scroll = (ItemScroll)item).getSortPref(stack, this.filterStack, (IItemHandler)new CombinedInvWrapper(new IItemHandlerModifiable[0]))) != ItemScroll.SortPref.INVALID) {
            return stack.getCount();
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.filterStack)) {
            return 0;
        }
        return this.filterStack.isEmpty() && stack.isEmpty() ? 1 : stack.getCount();
    }

    public void setReachedCount(boolean reachedCount) {
        boolean old = this.isPowered;
        this.isPowered = reachedCount;
        if (old != this.isPowered) {
            this.updateBlock();
            this.level.updateNeighborsAt(this.worldPosition, (Block)BlockRegistry.ITEM_DETECTOR.get());
        }
    }

    public boolean getPoweredState() {
        return this.inverted != this.isPowered;
    }

    public void addCount(int count) {
        this.neededCount += count;
        if (this.neededCount < 0) {
            this.neededCount = 0;
        }
        this.updateBlock();
    }

    public void setFilterStack(ItemStack stack) {
        this.filterStack = stack.copy();
        this.updateBlock();
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos != null) {
            if (this.level.getBlockEntity(storedPos) == null || this.level.getCapability(Capabilities.ItemHandler.BLOCK, storedPos, null) == null) {
                return;
            }
            if (BlockUtil.distanceFrom(storedPos, this.worldPosition) > 30.0) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.inv_too_far"));
                return;
            }
            this.connectedPos = storedPos.immutable();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.item_detector.connected", (Object[])new Object[]{storedPos.getX(), storedPos.getY(), storedPos.getZ()}));
            this.updateBlock();
        }
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.inverted = !this.inverted;
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.item_detector.inverted", (Object[])new Object[]{this.inverted}));
        this.updateBlock();
        this.level.updateNeighborsAt(this.worldPosition, (Block)BlockRegistry.ITEM_DETECTOR.get());
    }

    @Override
    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        if (this.connectedPos != null) {
            list.add(ColorPos.centered(this.connectedPos, ParticleColor.FROM_HIGHLIGHT));
        }
        return list;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (this.connectedPos != null) {
            tag.putLong("connectedPos", this.connectedPos.asLong());
        }
        tag.putInt("neededCount", this.neededCount);
        if (!this.filterStack.isEmpty()) {
            tag.put("filterStack", this.filterStack.save(pRegistries));
        }
        tag.putBoolean("isPowered", this.isPowered);
        tag.putBoolean("inverted", this.inverted);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("connectedPos")) {
            this.connectedPos = BlockPos.of((long)pTag.getLong("connectedPos"));
        }
        this.neededCount = pTag.getInt("neededCount");
        this.filterStack = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)pTag.getCompound("filterStack"));
        this.isPowered = pTag.getBoolean("isPowered");
        this.inverted = pTag.getBoolean("inverted");
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"ars_nouveau.item_detector.count", (Object[])new Object[]{(this.inverted ? "< " : "> ") + this.neededCount}));
        if (this.filterStack.getItem() instanceof ItemScroll) {
            ItemScrollData scrollData = (ItemScrollData)this.filterStack.getOrDefault(DataComponentRegistry.ITEM_SCROLL_DATA, (Object)new ItemScrollData(List.of()));
            for (ItemStack s : scrollData.getItems()) {
                tooltip.add((Component)Component.literal((String)s.getHoverName().getString()).withStyle(ChatFormatting.GOLD));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.item_detector.item", (Object[])new Object[]{this.filterStack.getHoverName().getString()}).withStyle(ChatFormatting.GOLD));
        }
        tooltip.add((Component)Component.translatable((String)"ars_nouveau.item_detector.powered", (Object[])new Object[]{this.getPoweredState()}));
    }
}

