/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.command;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class LearnGlyphCommand {
    private static final SuggestionProvider<CommandSourceStack> sugg = (ctx, builder) -> SharedSuggestionProvider.suggestResource(GlyphRegistry.getSpellpartMap().keySet(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ars-glyph").requires(sender -> sender.hasPermission(2))).executes(context -> LearnGlyphCommand.learnGlyph((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).getPlayer()), null))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(context -> LearnGlyphCommand.learnGlyph((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), null))).then(Commands.argument((String)"glyph", (ArgumentType)ResourceLocationArgument.id()).suggests(sugg).executes(context -> LearnGlyphCommand.learnGlyph((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), ResourceLocationArgument.getId((CommandContext)context, (String)"glyph"))))));
    }

    private static int learnGlyph(CommandSourceStack source, Collection<ServerPlayer> players, @Nullable ResourceLocation glyph) {
        if (source.getPlayer() == null) {
            return 0;
        }
        for (ServerPlayer player : players) {
            ANPlayerDataCap playerCap = CapabilityRegistry.getPlayerDataCap((LivingEntity)player);
            if (glyph == null) {
                if (playerCap == null) continue;
                playerCap.setKnownGlyphs(GlyphRegistry.getSpellpartMap().values().stream().filter(g -> !g.defaultedStarterGlyph()).toList());
                player.sendSystemMessage((Component)Component.literal((String)"Unlocked all glyphs"));
            } else {
                AbstractSpellPart spellPart = GlyphRegistry.getSpellPart(glyph);
                if (spellPart.defaultedStarterGlyph()) continue;
                boolean learned = playerCap.unlockGlyph(spellPart);
                if (learned) {
                    player.sendSystemMessage((Component)Component.literal((String)("Unlocked " + spellPart.getName())));
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)"Glyph already known"));
                }
            }
            CapabilityRegistry.EventHandler.syncPlayerCap((Player)player);
        }
        return 1;
    }
}

