/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.wixie;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.entity.goal.ExtendedRangeGoal;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CompleteCraftingGoal
extends ExtendedRangeGoal {
    EntityWixie wixie;
    int ticksNearby;
    boolean hasCast;

    public CompleteCraftingGoal(EntityWixie wixie) {
        super(10);
        this.wixie = wixie;
    }

    @Override
    public void start() {
        super.start();
        this.ticksNearby = 0;
        this.hasCast = false;
        this.startDistance = BlockUtil.distanceFrom(this.wixie.position, this.wixie.cauldronPos.above());
    }

    @Override
    public boolean canUse() {
        if (this.wixie.cauldronPos == null) {
            return false;
        }
        BlockEntity tileEntity = this.wixie.level.getBlockEntity(this.wixie.cauldronPos);
        return tileEntity instanceof WixieCauldronTile && ((WixieCauldronTile)tileEntity).isCraftingDone();
    }

    @Override
    public void tick() {
        super.tick();
        if (BlockUtil.distanceFrom(this.wixie.position(), this.wixie.cauldronPos.above()) < 1.5 + this.extendedRange) {
            WixieCauldronTile cauldronTile;
            BlockEntity tileEntity;
            ++this.ticksNearby;
            if (!this.hasCast) {
                this.wixie.inventoryBackoff = 40;
            }
            if (this.ticksNearby >= 40 && (tileEntity = this.wixie.level.getBlockEntity(this.wixie.cauldronPos)) instanceof WixieCauldronTile && (cauldronTile = (WixieCauldronTile)tileEntity).isCraftingDone()) {
                cauldronTile.attemptFinish();
            }
            this.hasCast = true;
        } else {
            this.setPath(this.wixie.cauldronPos.getX(), this.wixie.cauldronPos.getY(), this.wixie.cauldronPos.getZ(), 1.2);
        }
    }

    public void setPath(double x, double y, double z, double speedIn) {
        this.wixie.getNavigation().moveTo(this.wixie.getNavigation().createPath(x + 0.5, y + 1.5, z + 0.5, 0), speedIn);
    }
}

