/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos;

import com.hollingsworth.arsnouveau.api.registry.AlakarkinosConversionRegistry;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.crafting.recipes.AlakarkinosRecipe;
import com.hollingsworth.arsnouveau.common.entity.Alakarkinos;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos.CrabState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos.DecideCrabActionState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos.SpawnLootState;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ConvertBlockState
extends CrabState {
    BlockPos target;
    int waitTicks;
    boolean didBubbles;
    boolean spawnedFlyingItem;
    AlakarkinosRecipe recipe;

    public ConvertBlockState(Alakarkinos alakarkinos, BlockPos target) {
        super(alakarkinos);
        this.target = target;
    }

    @Override
    public void onEnd() {
        super.onEnd();
        this.alakarkinos.lookAt = null;
    }

    @Override
    @Nullable
    public CrabState tick() {
        super.tick();
        if (this.waitTicks > 0) {
            --this.waitTicks;
            return null;
        }
        if (BlockUtil.distanceFrom(this.alakarkinos.blockPosition(), this.target) > 2.0 && this.ticksRunning < 200) {
            this.alakarkinos.getNavigation().moveTo((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, 2, 1.0);
            return null;
        }
        if (!this.didBubbles) {
            this.alakarkinos.getNavigation().stop();
            this.alakarkinos.lookAt = Vec3.atCenterOf((Vec3i)this.target);
            this.didBubbles = true;
            this.waitTicks = 60;
            this.alakarkinos.setBlowingBubbles(true);
            this.alakarkinos.getEntityData().set(Alakarkinos.BLOWING_AT, Optional.of(this.target));
            return null;
        }
        BlockPos hatPos = this.alakarkinos.hatPos;
        if (hatPos == null) {
            return new DecideCrabActionState(this.alakarkinos);
        }
        if (!this.spawnedFlyingItem) {
            Block lootBlock = this.alakarkinos.level.getBlockState(this.target).getBlock();
            AlakarkinosRecipe res = AlakarkinosConversionRegistry.getConversionResult(lootBlock, this.alakarkinos.level.random);
            if (res == null) {
                return new DecideCrabActionState(this.alakarkinos);
            }
            this.recipe = res;
            this.spawnedFlyingItem = true;
            this.alakarkinos.setBlowingBubbles(false);
            EntityFlyingItem.spawn(this.alakarkinos.getHome(), (ServerLevel)this.alakarkinos.level, this.target, hatPos.above()).setStack(this.alakarkinos.level.getBlockState(this.target).getBlock().asItem().getDefaultInstance()).getEntityData().set(EntityFlyingItem.IS_BUBBLE, (Object)true);
            this.alakarkinos.level.setBlockAndUpdate(this.target, Blocks.AIR.defaultBlockState());
            this.waitTicks = 60;
            this.alakarkinos.setNeedSource(true);
            return null;
        }
        return new SpawnLootState(this.alakarkinos, this.recipe);
    }
}

