/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.event.SpellResolveEvent;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.entity.EntityOrbitProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.FakePlayer;

public class BreezeEvent
implements ITimedEvent {
    public Breeze breeze;
    int age;
    EntityOrbitProjectile orbitProjectile;
    Entity target;

    public BreezeEvent(Breeze breeze, EntityOrbitProjectile orbitProjectile, Entity target) {
        this.breeze = breeze;
        this.orbitProjectile = orbitProjectile;
        this.target = target;
    }

    @Override
    public void tick(boolean serverSide) {
        ++this.age;
        if (this.age % 8 == 0) {
            this.orbitProjectile.setAccelerates(this.orbitProjectile.getAccelerates() + 1);
        }
        if (this.age == 45) {
            this.orbitProjectile.remove(Entity.RemovalReason.DISCARDED);
            EntityProjectileSpell projectileSpell = new EntityProjectileSpell(this.breeze.level, new SpellResolver(SpellContext.fromEntity(this.orbitProjectile.resolver().spell, (LivingEntity)this.breeze, ItemStack.EMPTY)));
            projectileSpell.shoot(this.target.getX() - this.breeze.getX(), this.target.getY() - this.breeze.getY(), this.target.getZ() - this.breeze.getZ(), 1.0f, 0.0f);
            this.breeze.level.addFreshEntity((Entity)projectileSpell);
        }
    }

    @Override
    public boolean isExpired() {
        return this.age > 45 || this.breeze.isRemoved() || this.breeze.isDeadOrDying() || this.orbitProjectile.isRemoved() || this.target.isRemoved();
    }

    public static void onSpellResolve(SpellResolveEvent.Pre pre) {
        HitResult hitResult = pre.rayTraceResult;
        if (pre.context.getUnwrappedCaster() instanceof Breeze) {
            return;
        }
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            LivingEntity livingEntity = pre.shooter;
            if (livingEntity instanceof FakePlayer) {
                FakePlayer fakePlayer = (FakePlayer)livingEntity;
            } else {
                livingEntity = entityHitResult.getEntity();
                if (livingEntity instanceof Breeze) {
                    Breeze breeze = (Breeze)livingEntity;
                    if (pre.resolver.spell.getCastMethod() instanceof MethodProjectile) {
                        pre.setCanceled(true);
                        EntityOrbitProjectile orbitProjectile = new EntityOrbitProjectile(breeze.level, new SpellResolver(SpellContext.fromEntity(pre.spell, (LivingEntity)breeze, ItemStack.EMPTY)), entityHitResult.getEntity());
                        breeze.level.addFreshEntity((Entity)orbitProjectile);
                        EventQueue.getServerInstance().addEvent(new BreezeEvent(breeze, orbitProjectile, (Entity)pre.shooter));
                    }
                }
            }
        }
    }
}

