/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.en;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.analysis.CharArraySet;
import org.apache.lucene.ars_nouveau.analysis.LowerCaseFilter;
import org.apache.lucene.ars_nouveau.analysis.StopFilter;
import org.apache.lucene.ars_nouveau.analysis.StopwordAnalyzerBase;
import org.apache.lucene.ars_nouveau.analysis.TokenFilter;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.en.EnglishPossessiveFilter;
import org.apache.lucene.ars_nouveau.analysis.en.PorterStemFilter;
import org.apache.lucene.ars_nouveau.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.ars_nouveau.analysis.standard.StandardTokenizer;

public final class EnglishAnalyzer
extends StopwordAnalyzerBase {
    public static final CharArraySet ENGLISH_STOP_WORDS_SET;
    private final CharArraySet stemExclusionSet;

    public static CharArraySet getDefaultStopSet() {
        return ENGLISH_STOP_WORDS_SET;
    }

    public EnglishAnalyzer() {
        this(ENGLISH_STOP_WORDS_SET);
    }

    public EnglishAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public EnglishAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new EnglishPossessiveFilter(source);
        result = new LowerCaseFilter(result);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new PorterStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    static {
        List<String> stopWords = Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with");
        CharArraySet stopSet = new CharArraySet(stopWords, false);
        ENGLISH_STOP_WORDS_SET = CharArraySet.unmodifiableSet(stopSet);
    }
}

