/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.en;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.analysis.TokenFilter;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.en.KStemmer;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.KeywordAttribute;

public final class KStemFilter
extends TokenFilter {
    private final KStemmer stemmer = new KStemmer();
    private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAtt = this.addAttribute(KeywordAttribute.class);

    public KStemFilter(TokenStream in) {
        super(in);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] term = this.termAttribute.buffer();
        int len = this.termAttribute.length();
        if (!this.keywordAtt.isKeyword() && this.stemmer.stem(term, len)) {
            this.termAttribute.setEmpty().append(this.stemmer.asCharSequence());
        }
        return true;
    }
}

