/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.codecs.lucene99;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.ars_nouveau.codecs.CodecUtil;
import org.apache.lucene.ars_nouveau.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.ars_nouveau.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.ars_nouveau.codecs.lucene95.OffHeapByteVectorValues;
import org.apache.lucene.ars_nouveau.codecs.lucene95.OffHeapFloatVectorValues;
import org.apache.lucene.ars_nouveau.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.ars_nouveau.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.ars_nouveau.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.ars_nouveau.index.ByteVectorValues;
import org.apache.lucene.ars_nouveau.index.CorruptIndexException;
import org.apache.lucene.ars_nouveau.index.FieldInfo;
import org.apache.lucene.ars_nouveau.index.FieldInfos;
import org.apache.lucene.ars_nouveau.index.FloatVectorValues;
import org.apache.lucene.ars_nouveau.index.IndexFileNames;
import org.apache.lucene.ars_nouveau.index.KnnVectorValues;
import org.apache.lucene.ars_nouveau.index.SegmentReadState;
import org.apache.lucene.ars_nouveau.index.VectorEncoding;
import org.apache.lucene.ars_nouveau.index.VectorSimilarityFunction;
import org.apache.lucene.ars_nouveau.internal.hppc.IntObjectHashMap;
import org.apache.lucene.ars_nouveau.store.ChecksumIndexInput;
import org.apache.lucene.ars_nouveau.store.IOContext;
import org.apache.lucene.ars_nouveau.store.IndexInput;
import org.apache.lucene.ars_nouveau.store.ReadAdvice;
import org.apache.lucene.ars_nouveau.util.IOUtils;
import org.apache.lucene.ars_nouveau.util.RamUsageEstimator;
import org.apache.lucene.ars_nouveau.util.hnsw.RandomVectorScorer;

public final class Lucene99FlatVectorsReader
extends FlatVectorsReader {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Lucene99FlatVectorsFormat.class);
    private final IntObjectHashMap<FieldEntry> fields = new IntObjectHashMap();
    private final IndexInput vectorData;
    private final FieldInfos fieldInfos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene99FlatVectorsReader(SegmentReadState state, FlatVectorsScorer scorer) throws IOException {
        super(scorer);
        int versionMeta = this.readMetadata(state);
        this.fieldInfos = state.fieldInfos;
        boolean success = false;
        try {
            this.vectorData = Lucene99FlatVectorsReader.openDataInput(state, versionMeta, "vec", "Lucene99FlatVectorsFormatData", state.context.withReadAdvice(ReadAdvice.RANDOM));
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMetadata(SegmentReadState state) throws IOException {
        int versionMeta;
        block11: {
            String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vemf");
            versionMeta = -1;
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader(meta, "Lucene99FlatVectorsFormatMeta", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(meta, priorE);
                    }
                }
                CodecUtil.checkFooter(meta, priorE);
            }
        }
        return versionMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName, IOContext context) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, fileExtension);
            IndexInput in = state.directory.openInput(fileName, context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader(in, codecName, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, in);
                }
                CodecUtil.retrieveChecksum(in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(in);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        return indexInput;
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            FieldEntry fieldEntry = FieldEntry.create(meta, info);
            this.fields.put(info.number, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    @Override
    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.fields.ramBytesUsed();
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.vectorData);
    }

    @Override
    public FlatVectorsReader getMergeInstance() {
        try {
            this.vectorData.updateReadAdvice(ReadAdvice.SEQUENTIAL);
            return this;
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    private FieldEntry getFieldEntry(String field, VectorEncoding expectedEncoding) {
        FieldEntry fieldEntry;
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null || (fieldEntry = this.fields.get(info.number)) == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        if (fieldEntry.vectorEncoding != expectedEncoding) {
            throw new IllegalArgumentException("field=\"" + field + "\" is encoded as: " + String.valueOf((Object)fieldEntry.vectorEncoding) + " expected: " + String.valueOf((Object)expectedEncoding));
        }
        return fieldEntry;
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.FLOAT32);
        return OffHeapFloatVectorValues.load(fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.ordToDoc, fieldEntry.vectorEncoding, fieldEntry.dimension, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.vectorData);
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.BYTE);
        return OffHeapByteVectorValues.load(fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.ordToDoc, fieldEntry.vectorEncoding, fieldEntry.dimension, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.vectorData);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.FLOAT32);
        return this.vectorScorer.getRandomVectorScorer(fieldEntry.similarityFunction, (KnnVectorValues)OffHeapFloatVectorValues.load(fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.ordToDoc, fieldEntry.vectorEncoding, fieldEntry.dimension, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.vectorData), target);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.BYTE);
        return this.vectorScorer.getRandomVectorScorer(fieldEntry.similarityFunction, (KnnVectorValues)OffHeapByteVectorValues.load(fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.ordToDoc, fieldEntry.vectorEncoding, fieldEntry.dimension, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.vectorData), target);
    }

    @Override
    public void finishMerge() throws IOException {
        this.vectorData.updateReadAdvice(ReadAdvice.RANDOM);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.vectorData);
    }

    private record FieldEntry(VectorSimilarityFunction similarityFunction, VectorEncoding vectorEncoding, long vectorDataOffset, long vectorDataLength, int dimension, int size, OrdToDocDISIReaderConfiguration ordToDoc, FieldInfo info) {
        FieldEntry {
            if (similarityFunction != info.getVectorSimilarityFunction()) {
                throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + String.valueOf((Object)similarityFunction) + " != " + String.valueOf((Object)info.getVectorSimilarityFunction()));
            }
            int infoVectorDimension = info.getVectorDimension();
            if (infoVectorDimension != dimension) {
                throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + infoVectorDimension + " != " + dimension);
            }
            int byteSize = switch (info.getVectorEncoding()) {
                default -> throw new MatchException(null, null);
                case VectorEncoding.BYTE -> 1;
                case VectorEncoding.FLOAT32 -> 4;
            };
            long vectorBytes = Math.multiplyExact((long)infoVectorDimension, byteSize);
            long numBytes = Math.multiplyExact(vectorBytes, size);
            if (numBytes != vectorDataLength) {
                throw new IllegalStateException("Vector data length " + vectorDataLength + " not matching size=" + size + " * dim=" + dimension + " * byteSize=" + byteSize + " = " + numBytes);
            }
        }

        static FieldEntry create(IndexInput input, FieldInfo info) throws IOException {
            VectorEncoding vectorEncoding = Lucene99HnswVectorsReader.readVectorEncoding(input);
            VectorSimilarityFunction similarityFunction = Lucene99HnswVectorsReader.readSimilarityFunction(input);
            long vectorDataOffset = input.readVLong();
            long vectorDataLength = input.readVLong();
            int dimension = input.readVInt();
            int size = input.readInt();
            OrdToDocDISIReaderConfiguration ordToDoc = OrdToDocDISIReaderConfiguration.fromStoredMeta(input, size);
            return new FieldEntry(similarityFunction, vectorEncoding, vectorDataOffset, vectorDataLength, dimension, size, ordToDoc, info);
        }
    }
}

