/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.ars_nouveau.codecs.NormsProducer;
import org.apache.lucene.ars_nouveau.index.FieldInfo;
import org.apache.lucene.ars_nouveau.index.FieldInvertState;
import org.apache.lucene.ars_nouveau.index.SegmentWriteState;
import org.apache.lucene.ars_nouveau.index.Sorter;
import org.apache.lucene.ars_nouveau.index.TermsHashPerField;
import org.apache.lucene.ars_nouveau.util.ByteBlockPool;
import org.apache.lucene.ars_nouveau.util.Counter;
import org.apache.lucene.ars_nouveau.util.IntBlockPool;

abstract class TermsHash {
    final TermsHash nextTermsHash;
    final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    ByteBlockPool termBytePool;
    final Counter bytesUsed;

    TermsHash(IntBlockPool.Allocator intBlockAllocator, ByteBlockPool.Allocator byteBlockAllocator, Counter bytesUsed, TermsHash nextTermsHash) {
        this.nextTermsHash = nextTermsHash;
        this.bytesUsed = bytesUsed;
        this.intPool = new IntBlockPool(intBlockAllocator);
        this.bytePool = new ByteBlockPool(byteBlockAllocator);
        if (nextTermsHash != null) {
            this.termBytePool = this.bytePool;
            nextTermsHash.termBytePool = this.bytePool;
        }
    }

    public void abort() {
        try {
            this.reset();
        }
        finally {
            if (this.nextTermsHash != null) {
                this.nextTermsHash.abort();
            }
        }
    }

    void reset() {
        this.intPool.reset(false, false);
        this.bytePool.reset(false, false);
    }

    void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state, Sorter.DocMap sortMap, NormsProducer norms) throws IOException {
        if (this.nextTermsHash != null) {
            HashMap<String, TermsHashPerField> nextChildFields = new HashMap<String, TermsHashPerField>();
            for (Map.Entry<String, TermsHashPerField> entry : fieldsToFlush.entrySet()) {
                nextChildFields.put(entry.getKey(), entry.getValue().getNextPerField());
            }
            this.nextTermsHash.flush(nextChildFields, state, sortMap, norms);
        }
    }

    abstract TermsHashPerField addField(FieldInvertState var1, FieldInfo var2);

    void finishDocument(int docID) throws IOException {
        if (this.nextTermsHash != null) {
            this.nextTermsHash.finishDocument(docID);
        }
    }

    void startDocument() throws IOException {
        if (this.nextTermsHash != null) {
            this.nextTermsHash.startDocument();
        }
    }
}

