/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queryparser.flexible.standard.builders;

import org.apache.lucene.ars_nouveau.index.Term;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.nodes.FuzzyQueryNode;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.ars_nouveau.queryparser.flexible.standard.builders.StandardQueryBuilder;
import org.apache.lucene.ars_nouveau.search.FuzzyQuery;

public class FuzzyQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public FuzzyQuery build(QueryNode queryNode) throws QueryNodeException {
        FuzzyQueryNode fuzzyNode = (FuzzyQueryNode)queryNode;
        String text = fuzzyNode.getTextAsString();
        int numEdits = FuzzyQuery.floatToEdits(fuzzyNode.getSimilarity(), text.codePointCount(0, text.length()));
        return new FuzzyQuery(new Term(fuzzyNode.getFieldAsString(), fuzzyNode.getTextAsString()), numEdits, fuzzyNode.getPrefixLength());
    }
}

