/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queryparser.surround.query;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.index.IndexReader;
import org.apache.lucene.ars_nouveau.index.MultiTerms;
import org.apache.lucene.ars_nouveau.index.Term;
import org.apache.lucene.ars_nouveau.index.Terms;
import org.apache.lucene.ars_nouveau.index.TermsEnum;
import org.apache.lucene.ars_nouveau.queryparser.surround.query.SimpleTerm;
import org.apache.lucene.ars_nouveau.search.WildcardQuery;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.automaton.CompiledAutomaton;

public class SrndTruncQuery
extends SimpleTerm {
    private final String truncated;
    private final CompiledAutomaton compiled;

    public SrndTruncQuery(String truncated) {
        super(false);
        this.truncated = truncated;
        this.compiled = new CompiledAutomaton(WildcardQuery.toAutomaton(new Term(null, truncated), 10000), false, true, true);
    }

    public String getTruncated() {
        return this.truncated;
    }

    @Override
    public String toStringUnquoted() {
        return this.getTruncated();
    }

    @Override
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        Terms terms = MultiTerms.getTerms(reader, fieldName);
        if (terms != null) {
            BytesRef br;
            TermsEnum termsEnum = this.compiled.getTermsEnum(terms);
            while ((br = termsEnum.next()) != null) {
                mtv.visitMatchingTerm(new Term(fieldName, BytesRef.deepCopyOf(br)));
            }
        }
    }
}

