/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app;

import dev.kostromdan.mods.crash_assistant.app.class_loading.Boot;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReasonMessage;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogsList;
import dev.kostromdan.mods.crash_assistant.app.utils.CrashReportsHelper;
import dev.kostromdan.mods.crash_assistant.app.utils.FileUtils;
import dev.kostromdan.mods.crash_assistant.app.utils.HsErrHelper;
import dev.kostromdan.mods.crash_assistant.app.utils.TerminatedProcessesFinder;
import dev.kostromdan.mods.crash_assistant.app.utils.WinEventCleaner;
import dev.kostromdan.mods.crash_assistant.app.utils.gpu.GPU;
import dev.kostromdan.mods.crash_assistant.app.utils.gpu.RendererType;
import dev.kostromdan.mods.crash_assistant.common_config.communication.ProcessSignalIO;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantLocalConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.JavaBinaryLocator;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrashAssistantApp {
    public static final Logger LOGGER = LogManager.getLogger(CrashAssistantApp.class);
    public static long GUIStartTime = -1L;
    public static boolean GUIStartedLaunching = false;
    public static boolean GUIInitialisationFinished = false;
    public static String parentXms = null;
    public static String parentXmx = null;
    public static String systemRAM = null;
    public static String processor = null;
    public static boolean crashed = false;
    public static boolean crashed_with_report = false;
    public static boolean located_hs_err = false;
    public static String renderer = null;
    public static boolean gameLaunchedSuccessfully = false;
    public static boolean joinedWorldSuccessfully = false;
    public static boolean stopFunctionFired = false;
    public static boolean closeFunctionFailed = false;
    public static boolean emergencySaveFired = false;
    public static long terminatedProcessesLocationEndTime = 0L;
    public static String customLatestLogPath = null;

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> LOGGER.error("Uncaught exception in \"{}\" thread:", (Object)thread.getName(), (Object)throwable));
        LOGGER.info("CrashAssistantApp running: JVM args: {}", Boot.JVM_ARGS);
        LOGGER.info("CrashAssistantApp running: program args: {}", Boot.APP_ARGS);
        LOGGER.info("CrashAssistantApp running from: {}", (Object)Paths.get("", new String[0]).toAbsolutePath().toString());
        LOGGER.info("crashAssistantJarName: {}", (Object)Boot.crashAssistantModJarName);
        LOGGER.info("Parent PID: {}", (Object)Boot.parentPID);
        LOGGER.info("Parent started: {}", (Object)Boot.parentStarted);
        for (int i = 0; i < args.length; ++i) {
            if ("-parentXms".equals(args[i]) && i + 1 < args.length) {
                parentXms = args[i + 1];
                LOGGER.info("parentXms: {}", (Object)parentXms);
                continue;
            }
            if ("-parentXmx".equals(args[i]) && i + 1 < args.length) {
                parentXmx = args[i + 1];
                LOGGER.info("parentXmx: {}", (Object)parentXmx);
                continue;
            }
            if ("-systemRAM".equals(args[i]) && i + 1 < args.length) {
                systemRAM = args[i + 1];
                LOGGER.info("systemRAM: {}", (Object)systemRAM);
                continue;
            }
            if ("-processor".equals(args[i]) && i + 1 < args.length) {
                processor = new String(Base64.getDecoder().decode(args[i + 1]), StandardCharsets.UTF_8);
                LOGGER.info("processor: {}", (Object)processor);
                continue;
            }
            if ("-platform".equals(args[i]) && i + 1 < args.length) {
                PlatformHelp.platform = Enum.valueOf(PlatformHelp.class, args[i + 1]);
                LOGGER.info("Platform: {}", (Object)PlatformHelp.platform);
                continue;
            }
            if ("-loaderJarName".equals(args[i]) && i + 1 < args.length) {
                PlatformHelp.loaderJarName = args[i + 1];
                LOGGER.info("loaderJarName: {}", (Object)PlatformHelp.loaderJarName);
                continue;
            }
            if ("-minecraftVersion".equals(args[i]) && i + 1 < args.length) {
                PlatformHelp.minecraftVersion = args[i + 1];
                LOGGER.info("minecraftVersion: {}", (Object)PlatformHelp.minecraftVersion);
                continue;
            }
            if ("-childProcessesPIDs".equals(args[i]) && i + 1 < args.length) {
                PlatformHelp.childProcessesPIDs = new String(Base64.getDecoder().decode(args[i + 1]), StandardCharsets.UTF_8);
                LOGGER.info("childProcessesPIDs: {}", (Object)PlatformHelp.childProcessesPIDs);
                continue;
            }
            if (!"-customLatestLogPath".equals(args[i]) || i + 1 >= args.length) continue;
            customLatestLogPath = args[i + 1];
            LOGGER.info("customLatestLogPath: {}", (Object)customLatestLogPath);
        }
        LOGGER.info("Boot.serialisedGPUs:\n{}", (Object)Boot.serialisedGPUs);
        LOGGER.info("os.name: {}", (Object)PlatformHelp.OS);
        LOGGER.info("Java path: {}", (Object)JavaBinaryLocator.getJavaBinary());
        LOGGER.info("Java version: {}", (Object)PlatformHelp.javaVersion);
        String currentProcessData = Objects.toString(Boot.parentPID) + "_" + Boot.parentStarted;
        Path localFolder = Paths.get("local", "crash_assistant");
        Path currentProcessDataPath = localFolder.resolve(currentProcessData + ".info");
        try {
            Files.write(currentProcessDataPath, (ProcessHelper.getCurrentProcessId() + " : " + ProcessHelper.getCurrentProcessStartTime()).getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.deleteIfExists(localFolder.resolve(currentProcessData + "_gpu_detect.cs"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileUtils.removeTmpFiles(localFolder);
        FileUtils.removeOldLogsFolder();
        WinEventCleaner.cleanOldWinEventFiles();
        HsErrHelper.removeHsErrLog(Boot.parentPID);
        LOGGER.info("CrashAssistantApp started successfully. Waiting for PID " + Boot.parentPID + " to stop.");
        try {
            while (true) {
                if (Boot.parentStarted == -1L || Boot.parentStarted != ProcessHelper.getProcessStartTime((long)Boot.parentPID)) {
                    LOGGER.info("PID \"{}\" is not alive or reused by another process. Minecraft JVM appears to have stopped.", (Object)Boot.parentPID);
                    CrashAssistantApp.onMinecraftFinished();
                    return;
                }
                if (CrashAssistantApp.checkLoadingErrorScreen()) {
                    return;
                }
                CrashAssistantApp.checkRendererFile();
                System.gc();
                TimeUnit.SECONDS.sleep(1L);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while awaiting Minecraft stop:", (Throwable)e);
            return;
        }
    }

    private static boolean checkLoadingErrorScreen() {
        if (ProcessSignalIO.exists((String)"loading_error_fml", (long)Boot.parentPID)) {
            LOGGER.info("Detected FML error modloading screen.");
            if (CrashAssistantConfig.getBoolean((String)"general.show_on_fml_error_screen")) {
                CrashAssistantApp.onMinecraftFinished();
            }
            return true;
        }
        return false;
    }

    public static void checkRendererFile() {
        if (renderer != null) {
            return;
        }
        if (Boot.serialisedGPUs == null) {
            return;
        }
        Optional potentialRenderer = ProcessSignalIO.get((String)"renderer", (long)Boot.parentPID);
        if (potentialRenderer.isPresent()) {
            try {
                renderer = (String)potentialRenderer.get();
                String normalizedRenderer = CrashAssistantApp.removeSpacesAndLowerCase(renderer);
                LOGGER.info("Minecraft is running on renderer:\n{}", (Object)renderer);
                if (Boot.serialisedGPUs != null) {
                    List<GPU> gpus = GPU.deserializeGPUs(Boot.serialisedGPUs);
                    ArrayList<String> dedicatedGpus = new ArrayList<String>();
                    Optional<Object> foundGPU = Optional.empty();
                    for (GPU gpu : gpus) {
                        String normalizedGpuName;
                        if (gpu.getType() == RendererType.DEDICATED) {
                            dedicatedGpus.add(gpu.getName());
                        }
                        if (!(normalizedGpuName = CrashAssistantApp.removeSpacesAndLowerCase(gpu.getName())).contains(normalizedRenderer) && !normalizedRenderer.contains(normalizedGpuName)) continue;
                        foundGPU = Optional.of(gpu);
                    }
                    if (foundGPU.isPresent() && ((GPU)foundGPU.get()).getType() == RendererType.INTEGRATED && !dedicatedGpus.isEmpty()) {
                        LOGGER.warn("Detected Minecraft running on integrated GPU:\n{},\nwhile one or more dedicated exists:\n{}", (Object)((GPU)foundGPU.get()).getName(), (Object)String.join((CharSequence)"\n", dedicatedGpus));
                        if (Objects.equals(CrashAssistantLocalConfig.get((String)"integrated_gpu.dont_show_again"), true)) {
                            LOGGER.warn("integrated_gpu.dont_show_again is true. Prevented GUI warn.");
                            return;
                        }
                        try {
                            Class<?> clazz = Class.forName("dev.kostromdan.mods.crash_assistant.app.gui.IntegratedGPUWarning");
                            Method method = clazz.getMethod("show", String.class, List.class);
                            method.invoke(null, ((GPU)foundGPU.get()).getName(), dedicatedGpus);
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception while showing IntegratedGPUWarning:", (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception while analysis of current GPUs:", (Throwable)e);
                renderer = "UNDEFINED";
            }
        }
    }

    private static String removeSpacesAndLowerCase(String s) {
        return s.toLowerCase().replace(" ", "");
    }

    private static void onMinecraftFinished() {
        String userHome;
        GUIStartTime = Instant.now().toEpochMilli();
        new Thread(LanguageProvider::updateLang).start();
        LogsList.addIfExistsAndModified(new Log(LogType.LOG, customLatestLogPath == null ? Paths.get("logs", "latest.log") : Paths.get(customLatestLogPath, new String[0])));
        LogsList.addIfExistsAndModified(new Log(LogType.DEBUG_LOG, Paths.get("logs", "debug.log")));
        CrashAssistantApp.locateAndAddHsErr();
        HashSet<Path> newCrashReports = CrashReportsHelper.getRelevantFiles(Paths.get("crash-reports", new String[0]), path -> true);
        if (!newCrashReports.isEmpty()) {
            crashed = true;
            crashed_with_report = true;
            for (Path path2 : newCrashReports) {
                LogsList.addIfExistsAndModified(new Log(LogType.CRASH_REPORT, path2));
            }
        }
        HashSet<Path> disconnectsClient = CrashReportsHelper.getRelevantFiles(Paths.get("minecraft", "debug"), path -> path.startsWith("disconnect-") && path.endsWith("-client.txt"));
        for (Path path3 : disconnectsClient) {
            LogsList.addIfExistsAndModified(new Log(LogType.DISCONNECT_CLIENT, path3));
        }
        Log log = new Log(LogType.LAUNCHER_LOG, Paths.get("logs", "stderr_stream.log"));
        long logSizeBytes = log.getFile().length();
        LOGGER.info("stderr_stream.log size: {} bytes", (Object)logSizeBytes);
        if (Files.isRegularFile(log.getPath(), new LinkOption[0]) && logSizeBytes >= 400L) {
            boolean add = true;
            if (logSizeBytes < 0x100000L) {
                log.getReader().readLogFileSafe();
                String logContents = log.getReader().getAllLinesString();
                if (logContents != null && !logContents.isEmpty()) {
                    add = Pattern.compile("^.*\\bat\\s+\\S+", 8).matcher(logContents).find();
                }
            }
            if (add) {
                LogsList.addIfExistsAndModified(log);
            }
        }
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "MinecraftLauncher: launcher_log.txt", Paths.get("launcher_log.txt", new String[0])));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("logs", "launcher_log.txt")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "CurseForge: launcher_log.txt", Paths.get("../../Install", "launcher_log.txt")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("../../logs", "ftb-app-electron.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("../../../logs", "PrismLauncher-0.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "GDLauncher: main.log", Paths.get("../../../../", "main.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("../../../", "MultiMC-0.log")));
        FileUtils.getModifiedFiles(Paths.get("../../launcher_logs", new String[0]), ".log").forEach(path -> LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, (Path)path)));
        String appdata = System.getenv("APPDATA");
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("../../logs", "atlauncher.log")));
        if (appdata != null) {
            LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get(appdata, "AtLauncher", "logs", "atlauncher.log")));
            FileUtils.getModifiedFiles(Paths.get(appdata, ".tlauncher", "logs", "tlauncher"), ".log").forEach(path -> LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, (Path)path)));
            LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "LegacyLauncher: launcher.log", Paths.get(appdata, ".tlauncher", "logs", "launcher.log")));
        }
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("../../../logs", "ElyPrismLauncher-0.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "CrystalLauncher: latest.log", Paths.get("../../../../Crystal-Launcher/logs", "latest.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "KLauncher: game.log", Paths.get("logs/klauncher", "game.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "KLauncher: launcher.log", Paths.get("logs/klauncher", "launcher.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("sklauncher", "sklauncher_logs.txt")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("../../../", "PolyMC-0.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("../../../logs", "PollyMC-0.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "Feather: latest.log", Paths.get("feather/logs", "latest.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "Lunar: ichor-boot.log", customLatestLogPath == null ? Paths.get("logs", "ichor-boot.log") : Paths.get(customLatestLogPath, new String[0]).getParent().resolve("ichor-boot.log")));
        if (FileUtils.folderNLevelsUpperNameContains(2, "technic")) {
            FileUtils.getModifiedFiles(Paths.get("../../logs", new String[0]), ".log").forEach(path -> LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, (Path)path)));
        }
        if ((userHome = System.getProperty("user.home")) != null) {
            Path applicationSupportPath = Paths.get(userHome, "Library", "Application Support");
            if (Files.exists(applicationSupportPath, new LinkOption[0])) {
                LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "CurseForge: launcher_log.txt", Paths.get(applicationSupportPath.toString(), "minecraft", "launcher_log.txt")));
                FileUtils.getModifiedFiles(Paths.get(applicationSupportPath.toString(), "tlauncher", "logs", "tlauncher"), ".log").forEach(path -> LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, (Path)path)));
                LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "LegacyLauncher: launcher.log", Paths.get(applicationSupportPath.toString(), "tlauncher", "logs", "launcher.log")));
            }
            LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "CurseForge: launcher_log.txt", Paths.get(userHome, ".minecraft", "launcher_log.txt")));
            FileUtils.getModifiedFiles(Paths.get(userHome, ".tlauncher", "logs", "tlauncher"), ".log").forEach(path -> LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, (Path)path)));
            LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "LegacyLauncher: launcher.log", Paths.get(userHome, ".tlauncher", "logs", "launcher.log")));
        }
        LogsList.addIfExistsAndModified(new Log(LogType.MIXER_LOGGER, Paths.get("logs", "MixerLogger.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.KUBE_JS, "KubeJS: client.log", Paths.get("logs", "kubejs", "client.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.KUBE_JS, "KubeJS: server.log", Paths.get("logs", "kubejs", "server.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.KUBE_JS, "KubeJS: startup.log", Paths.get("logs", "kubejs", "startup.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.CRAFT_TWEAKER, Paths.get("logs", "crafttweaker.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.REI, Paths.get("logs", "rei.log")));
        Path reiIssuesPath = Paths.get("logs", "rei-issues.log");
        try {
            if (reiIssuesPath.toFile().exists() && Files.size(reiIssuesPath) != 0L) {
                LogsList.addIfExistsAndModified(new Log(LogType.REI, reiIssuesPath));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LogsList.addIfExistsAndModified(new Log(LogType.CRASH_ASSISTANT, Paths.get("logs", "crash_assistant", "crash_assistant_app.log")));
        gameLaunchedSuccessfully = ProcessSignalIO.exists((String)"successful_launch", (long)Boot.parentPID);
        LOGGER.info("Reached first tick of TitleScreen: {}", (Object)gameLaunchedSuccessfully);
        joinedWorldSuccessfully = ProcessSignalIO.exists((String)"joined_world", (long)Boot.parentPID);
        LOGGER.info("Joined world successfully: {}", (Object)joinedWorldSuccessfully);
        stopFunctionFired = ProcessSignalIO.exists((String)"normal_stop", (long)Boot.parentPID);
        if (!stopFunctionFired) {
            crashed = true;
        }
        LOGGER.info("stop() function of Minecraft fired: {}", (Object)stopFunctionFired);
        closeFunctionFailed = ProcessSignalIO.exists((String)"close_failed", (long)Boot.parentPID);
        if (closeFunctionFailed) {
            crashed = true;
        }
        LOGGER.info("close() function of Minecraft failed: {}", (Object)closeFunctionFailed);
        emergencySaveFired = ProcessSignalIO.exists((String)"emergency_save", (long)Boot.parentPID);
        if (emergencySaveFired) {
            crashed = true;
        }
        LOGGER.info("emergencySave() function of Minecraft fired: {}", (Object)emergencySaveFired);
        LOGGER.info("isModpackCreator: {}", (Object)ModListDiff.isModpackCreator());
        LOGGER.info("isHelpLinkDefault: {}", (Object)PlatformHelp.isLinkDefault());
        LOGGER.info("helpLink: {}", (Object)PlatformHelp.getActualHelpLink());
        CrashAssistantApp.startLocatingTerminatedProcesses();
        if (crashed) {
            if (!crashed_with_report) {
                LOGGER.info("Seems like Minecraft crashed without any crash report. Starting Crash Assistant app.");
            } else {
                LOGGER.info("Seems like Minecraft crashed. Starting Crash Assistant app.");
            }
            CrashAssistantApp.onMinecraftCrashed();
        } else {
            LOGGER.info("Seems like Minecraft finished normally. Trying to locate terminated processes and Exiting Crash Assistant app.");
        }
    }

    private static void onMinecraftCrashed() {
        CrashAssistantApp.startApp();
    }

    public static void startApp() {
        GUIStartedLaunching = true;
        try {
            Class<?> clazz = Class.forName("dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Exception while starting gui:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean locateAndAddHsErr() {
        if (located_hs_err) {
            return false;
        }
        Optional<Path> hsErrLog = HsErrHelper.locateHsErrLog(Boot.parentPID);
        if (hsErrLog.isPresent()) {
            crashed = true;
            crashed_with_report = true;
            located_hs_err = true;
            Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
            synchronized (KnownCrashReasonMessage.class) {
                LogsList.addIfExistsAndModified(new Log(LogType.HS_ERR, hsErrLog.get()));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
        }
        return false;
    }

    public static void callUpdateLogsListInGUI() {
        try {
            Class<?> clazz = Class.forName("dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI");
            Method method = clazz.getMethod("updateLogsListInGUI", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Exception adding file to gui later:", (Throwable)e);
        }
    }

    public static void waitGuiInitialisationFinished() {
        long startTime = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() >= startTime + 7000L) {
                LOGGER.error("Reached timeout while waiting for GUI initialisation finished.");
                System.exit(-1);
            }
            if (GUIInitialisationFinished) break;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void startLocatingTerminatedProcesses() {
        new Thread(() -> {
            long startTime = System.currentTimeMillis();
            terminatedProcessesLocationEndTime = System.currentTimeMillis() + 7000L;
            boolean firstIteration = true;
            while (System.currentTimeMillis() < terminatedProcessesLocationEndTime) {
                try {
                    Thread.sleep(firstIteration ? 3000L : 100L);
                    if (firstIteration && CrashAssistantApp.locateAndAddHsErr()) {
                        LOGGER.info("Added hs_err log later.");
                        CrashAssistantApp.waitGuiInitialisationFinished();
                        CrashAssistantApp.callUpdateLogsListInGUI();
                    }
                    firstIteration = false;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Path terminatedProcessesPath = Paths.get(TerminatedProcessesFinder.getTerminatedByWinProcessLogs(), new String[0]);
                if (!terminatedProcessesPath.toFile().isFile()) continue;
                LOGGER.info("Time to locate terminated process: " + (System.currentTimeMillis() - startTime));
                Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
                synchronized (KnownCrashReasonMessage.class) {
                    LogsList.addIfExistsAndModified(new Log(LogType.WIN_EVENT, terminatedProcessesPath));
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    if (!GUIStartedLaunching) {
                        CrashAssistantApp.onMinecraftCrashed();
                        return;
                    }
                    CrashAssistantApp.waitGuiInitialisationFinished();
                    CrashAssistantApp.callUpdateLogsListInGUI();
                    terminatedProcessesLocationEndTime = System.currentTimeMillis();
                    return;
                }
            }
        }).start();
    }
}

