/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.analysis;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.AnalysisGUIBase;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class CorruptedJarFinderGUI
extends AnalysisGUIBase {
    private static final String ERROR_PLACEHOLDER = "$ERROR$";

    public CorruptedJarFinderGUI(JFrame parent) {
        super(parent, LanguageProvider.get((String)"gui.menu.analysis.corrupted_jar_finder"), LanguageProvider.get((String)"gui.analysis.corrupted_jar_finder.header"));
    }

    public static void showDialog(JFrame parent) {
        new CorruptedJarFinderGUI(parent).start();
    }

    @Override
    protected void performAnalysis() {
        List<Path> archives = CorruptedJarFinderGUI.discoverArchives();
        int totalArchives = archives.size();
        AtomicInteger completedTasks = new AtomicInteger(0);
        AtomicBoolean headerShown = new AtomicBoolean(false);
        AtomicBoolean anyCorruptionFound = new AtomicBoolean(false);
        SwingUtilities.invokeLater(() -> this.progressBar.setMaximum(Math.max(1, totalArchives)));
        for (Path jarPath : archives) {
            executor.submit(() -> {
                if (isCancelled) {
                    return;
                }
                String topId = CorruptedJarFinderGUI.toModsRelative(jarPath);
                SwingUtilities.invokeLater(() -> this.currentJarLabel.setText(LanguageProvider.get((String)"gui.analysis.current_mod") + " " + topId));
                List<CorruptionRecord> records = CorruptedJarFinderGUI.inspectJarAndNested(jarPath, topId);
                if (!records.isEmpty()) {
                    if (Files.exists(jarPath, new LinkOption[0])) {
                        this.registerDetectedModJar(topId);
                    }
                    anyCorruptionFound.set(true);
                    CorruptedJarFinderGUI.logCorruptions(records);
                    List<CorruptionRecord> modRecords = Collections.unmodifiableList(new ArrayList<CorruptionRecord>(records));
                    SwingUtilities.invokeLater(() -> {
                        boolean first = headerShown.compareAndSet(false, true);
                        this.appendResultsForMod(topId, modRecords, first);
                    });
                }
                int completed = completedTasks.incrementAndGet();
                SwingUtilities.invokeLater(() -> {
                    if (!isCancelled) {
                        this.progressBar.setValue(completed);
                    }
                });
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!isCancelled && !anyCorruptionFound.get()) {
            SwingUtilities.invokeLater(() -> this.appendStyledText(LanguageProvider.get((String)"gui.analysis.corrupted_jar_finder.no_issues"), NORMAL_COLOR));
        }
    }

    private static List<Path> discoverArchives() {
        List<Path> list;
        block9: {
            Path modsFolder = ModListUtils.MODS_FOLDER;
            if (!Files.isDirectory(modsFolder, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> stream = Files.walk(modsFolder, new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> CorruptedJarFinderGUI.isArchive(path.getFileName().toString())).sorted().collect(Collectors.toList());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    CrashAssistantApp.LOGGER.error("Failed to enumerate mods folder for CorruptedJarFinder", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    private static boolean isArchive(String name) {
        String lower = name.toLowerCase(Locale.ROOT);
        return lower.endsWith(".jar") || lower.endsWith(".zip");
    }

    private static boolean isInnerArchiveName(String entryName) {
        String lower = entryName.toLowerCase(Locale.ROOT);
        return lower.endsWith(".jar") || lower.endsWith(".zip");
    }

    private static String toModsRelative(Path jarPath) {
        Path modsFolder = ModListUtils.MODS_FOLDER.toAbsolutePath().normalize();
        Path normalized = jarPath.toAbsolutePath().normalize();
        if (normalized.startsWith(modsFolder)) {
            Path relative = modsFolder.relativize(normalized);
            return relative.toString().replace('\\', '/');
        }
        Path name = normalized.getFileName();
        return name != null ? name.toString() : normalized.toString();
    }

    private void appendResultsForMod(String jarName, List<CorruptionRecord> records, boolean isFirst) {
        if (isFirst) {
            this.appendStyledText(LanguageProvider.get((String)"gui.analysis.corrupted_jar_finder.found_header") + "\n", NORMAL_COLOR);
        }
        this.appendStyledText(jarName + "\n", MOD_COLOR);
        for (CorruptionRecord record : records) {
            String containerDisplay = CorruptedJarFinderGUI.deriveDisplayName(jarName, record.containerId);
            this.appendStyledText("  - " + containerDisplay + ": " + record.formattedReason() + "\n", ERROR_COLOR);
        }
        this.appendStyledText("\n", NORMAL_COLOR);
    }

    private static String deriveDisplayName(String rootJar, String containerId) {
        if (containerId.equals(rootJar)) {
            return LanguageProvider.get((String)"gui.analysis.corrupted_jar_finder.root_container");
        }
        String prefix = rootJar + "!/";
        if (containerId.startsWith(prefix)) {
            return containerId.substring(prefix.length());
        }
        return containerId;
    }

    private static void logCorruptions(List<CorruptionRecord> records) {
        for (CorruptionRecord record : records) {
            CrashAssistantApp.LOGGER.warn("[CorruptedJarFinder] {} -> {}", (Object)record.containerId, (Object)record.formattedReason());
        }
    }

    private static List<CorruptionRecord> inspectJarAndNested(Path jarPath, String topId) {
        ArrayList<CorruptionRecord> records = new ArrayList<CorruptionRecord>();
        if (!Files.exists(jarPath, new LinkOption[0])) {
            records.add(new CorruptionRecord(topId, CorruptionReason.MISSING, null));
            return records;
        }
        if (!Files.isRegularFile(jarPath, new LinkOption[0])) {
            records.add(new CorruptionRecord(topId, CorruptionReason.NOT_A_FILE, null));
            return records;
        }
        try {
            long size = Files.size(jarPath);
            if (size == 0L) {
                records.add(new CorruptionRecord(topId, CorruptionReason.EMPTY, null));
                return records;
            }
        }
        catch (IOException e2) {
            records.add(new CorruptionRecord(topId, CorruptionReason.IO_ERROR, e2.getMessage()));
        }
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        try (JarFile jarFile = new JarFile(jarPath.toFile());){
            boolean hasAnyFile = jarFile.stream().anyMatch(e -> !e.isDirectory());
            if (!hasAnyFile) {
                CorruptedJarFinderGUI.addRecord(records, visited, new CorruptionRecord(topId, CorruptionReason.EMPTY, null));
            }
            ArrayList<JarEntry> entries = Collections.list(jarFile.entries());
            for (JarEntry e3 : entries) {
                if (e3.isDirectory()) continue;
                String entryId = topId + "!/" + e3.getName();
                try {
                    InputStream is = jarFile.getInputStream(e3);
                    try {
                        if (CorruptedJarFinderGUI.isInnerArchiveName(e3.getName())) {
                            byte[] inner = CorruptedJarFinderGUI.readAllBytes(is);
                            if (inner.length == 0 || e3.getSize() == 0L) {
                                CorruptedJarFinderGUI.addRecord(records, visited, new CorruptionRecord(entryId, CorruptionReason.EMPTY, null));
                                continue;
                            }
                            CorruptedJarFinderGUI.validateInnerArchiveViaJarFile(entryId, inner, records, visited);
                            continue;
                        }
                        CorruptedJarFinderGUI.drain(is);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (ZipException ze) {
                    CorruptedJarFinderGUI.addRecord(records, visited, new CorruptionRecord(entryId, CorruptionReason.ZIP_ERROR, ze.getMessage()));
                }
                catch (IOException ioe) {
                    CorruptedJarFinderGUI.addRecord(records, visited, new CorruptionRecord(entryId, CorruptionReason.IO_ERROR, ioe.getMessage()));
                }
            }
        }
        catch (ZipException zipException) {
            CorruptedJarFinderGUI.addRecord(records, visited, new CorruptionRecord(topId, CorruptionReason.ZIP_ERROR, zipException.getMessage()));
        }
        catch (IOException ioException) {
            CorruptedJarFinderGUI.addRecord(records, visited, new CorruptionRecord(topId, CorruptionReason.IO_ERROR, ioException.getMessage()));
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void validateInnerArchiveViaJarFile(String containerId, byte[] data, List<CorruptionRecord> records, Set<String> visited) {
        Path tmp = null;
        String suffix23333332 = containerId.toLowerCase(Locale.ROOT).endsWith(".zip") ? ".zip" : ".jar";
        tmp = Files.createTempFile("caf-nested-", suffix23333332, new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(tmp, new OpenOption[0]);){
            os.write(data);
        }
        try (JarFile jf = new JarFile(tmp.toFile());){
            boolean sawAnyFile = jf.stream().anyMatch(e -> !e.isDirectory());
            if (!sawAnyFile) {
                CorruptedJarFinderGUI.addRecord(records, visited, new CorruptionRecord(containerId, CorruptionReason.EMPTY, null));
            }
            ArrayList<JarEntry> entries = Collections.list(jf.entries());
            for (JarEntry e2 : entries) {
                if (e2.isDirectory()) continue;
                String nextId = containerId + "!/" + e2.getName();
                try {
                    InputStream is = jf.getInputStream(e2);
                    try {
                        if (CorruptedJarFinderGUI.isInnerArchiveName(e2.getName())) {
                            byte[] nested = CorruptedJarFinderGUI.readAllBytes(is);
                            if (nested.length == 0 || e2.getSize() == 0L) {
                                CorruptedJarFinderGUI.addRecord(records, visited, new CorruptionRecord(nextId, CorruptionReason.EMPTY, null));
                                continue;
                            }
                            CorruptedJarFinderGUI.validateInnerArchiveViaJarFile(nextId, nested, records, visited);
                            continue;
                        }
                        CorruptedJarFinderGUI.drain(is);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (ZipException ze) {
                    CorruptedJarFinderGUI.addRecord(records, visited, new CorruptionRecord(nextId, CorruptionReason.ZIP_ERROR, ze.getMessage()));
                }
                catch (IOException ioe) {
                    CorruptedJarFinderGUI.addRecord(records, visited, new CorruptionRecord(nextId, CorruptionReason.IO_ERROR, ioe.getMessage()));
                }
            }
        }
        if (tmp == null) return;
        try {
            Files.deleteIfExists(tmp);
            return;
        }
        catch (IOException suffix23333332) {}
        return;
        catch (ZipException ze2222222) {
            CorruptedJarFinderGUI.addRecord(records, visited, new CorruptionRecord(containerId, CorruptionReason.ZIP_ERROR, ze2222222.getMessage()));
            if (tmp == null) return;
            try {
                Files.deleteIfExists(tmp);
                return;
            }
            catch (IOException ze2222222) {}
            return;
        }
        catch (IOException ioe) {
            CorruptedJarFinderGUI.addRecord(records, visited, new CorruptionRecord(containerId, CorruptionReason.IO_ERROR, ioe.getMessage()));
            if (tmp == null) return;
            {
                catch (Throwable throwable) {
                    if (tmp == null) throw throwable;
                    try {
                        Files.deleteIfExists(tmp);
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                Files.deleteIfExists(tmp);
                return;
            }
            catch (IOException iOException) {}
            return;
        }
    }

    private static void addRecord(List<CorruptionRecord> out, Set<String> visited, CorruptionRecord rec) {
        String deDupKey = rec.containerId + "|" + rec.reason.name() + "|" + (rec.detail == null ? "" : rec.detail);
        if (visited.add(deDupKey)) {
            out.add(rec);
        }
    }

    private static void drain(InputStream in) throws IOException {
        byte[] buf = new byte[8192];
        while (in.read(buf) != -1) {
        }
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((read = in.read(data)) != -1) {
            buffer.write(data, 0, read);
        }
        return buffer.toByteArray();
    }

    private static final class CorruptionRecord {
        final String containerId;
        final CorruptionReason reason;
        final String detail;

        CorruptionRecord(String containerId, CorruptionReason reason, String detail) {
            this.containerId = containerId;
            this.reason = reason;
            this.detail = detail;
        }

        String formattedReason() {
            return this.reason.format(this.detail);
        }
    }

    private static enum CorruptionReason {
        MISSING("gui.analysis.corrupted_jar_finder.reason.missing", false),
        NOT_A_FILE("gui.analysis.corrupted_jar_finder.reason.not_a_file", false),
        EMPTY("gui.analysis.corrupted_jar_finder.reason.empty", false),
        ZIP_ERROR("gui.analysis.corrupted_jar_finder.reason.zip_error", true),
        IO_ERROR("gui.analysis.corrupted_jar_finder.reason.io_error", true);

        private final String langKey;
        private final boolean usesError;

        private CorruptionReason(String langKey, boolean usesError) {
            this.langKey = langKey;
            this.usesError = usesError;
        }

        public String format(String detail) {
            String template = LanguageProvider.get((String)this.langKey);
            if (this.usesError) {
                String replacement = detail == null ? "" : detail;
                return template.replace(CorruptedJarFinderGUI.ERROR_PLACEHOLDER, replacement);
            }
            return template;
        }
    }
}

