/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log;

import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.maven_version_cmp.VersionUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GeckoLibOculusCompat
extends KnownCrashReason {
    public GeckoLibOculusCompat() {
        super(LogType.LOG, LanguageProvider.get((String)"warnings.geckolib_oculus_compat"), new String[0]);
    }

    @Override
    public boolean matches(Log log) {
        if (VersionUtils.isLower((String)PlatformHelp.minecraftVersion, (String)"1.20.1")) {
            return false;
        }
        List detectedMods = ModListUtils.getCurrentModList((boolean)true).stream().filter(mod -> Objects.equals(mod.getModId(), "geckoanimfix")).collect(Collectors.toList());
        if (detectedMods.isEmpty()) {
            return false;
        }
        this.message = this.message.replace("$JAR_NAME$", "<strong style='color: red;'>" + ((Mod)detectedMods.get(0)).getJarName() + "</strong>");
        return true;
    }
}

