/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log;

import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LinksProvider;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.maven_version_cmp.VersionUtils;
import java.util.HashSet;

public class LegacyTooManyIds
extends KnownCrashReason {
    public LegacyTooManyIds() {
        super(new HashSet<LogType>(){
            {
                this.add(LogType.LOG);
                this.add(LogType.CRASH_REPORT);
            }
        }, LanguageProvider.get((String)"warnings.legacy_too_many_ids"), "java\\.lang\\.RuntimeException: Invalid id 4096 - maximum id range exceeded\\.");
    }

    @Override
    public boolean matches(Log log) {
        if (PlatformHelp.platform != PlatformHelp.FORGE) {
            return false;
        }
        if (VersionUtils.isGreater((String)PlatformHelp.minecraftVersion, (String)"1.12.2")) {
            return false;
        }
        this.message = PlatformHelp.minecraftVersion.equals("1.12.2") ? this.message.replace("$MOD_LINK$", "<a href=\"" + LinksProvider.ROUGHLY_ENOUGH_IDS.getLink() + "\">Roughly Enough IDs</a>") : this.message.replace("$MOD_LINK$", "<a href=\"" + LinksProvider.NOT_ENOUGH_IDS.getLink() + "\">NotEnoughIDs</a>");
        return super.matches(log);
    }
}

