/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.generatorgalore.registry.GeneratorRegistry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;

public record GeneratorExistsCondition(ResourceLocation generatorName) implements ICondition
{
    public static MapCodec<GeneratorExistsCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("generator").forGetter(GeneratorExistsCondition::generatorName)).apply((Applicative)builder, GeneratorExistsCondition::new));

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    public boolean test(ICondition.IContext context) {
        return GeneratorRegistry.generators.containsKey(this.generatorName);
    }

    @Override
    public String toString() {
        return "generator_exists(\"" + String.valueOf(this.generatorName) + "\")";
    }
}

