/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.data;

import cy.jdkdigital.generatorgalore.registry.GeneratorRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public class LanguageProvider
extends net.neoforged.neoforge.common.data.LanguageProvider {
    public LanguageProvider(PackOutput output) {
        super(output, "generatorgalore", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.generatorgalore", "Generator Galore");
        this.add("generatorgalore.screen.empty", "Empty");
        this.add("generatorgalore.screen.energy_level", "Energy: %s");
        this.add("generatorgalore.screen.fluid_level", "%s: %s");
        this.add("generatorgalore.screen.fuel_time", "Remaining fuel time: %s");
        this.add("generatorgalore.screen.generation_rate", "Rate: %sFE/t");
        this.add("generatorgalore.screen.transfer_rate", "Transfer rate: %sFE/t");
        this.add("generatorgalore.screen.max_energy", "Max energy: %sFE");
        this.add("generatorgalore.screen.fuel_type", "Fuel type: %s");
        this.add("generatorgalore.recipe.solid_fuel", "Solid Fuel");
        this.add("generatorgalore.recipe.fluid_fuel", "Fluid Fuel");
        GeneratorRegistry.generators.forEach((resourceLocation, generatorObject) -> {
            this.add("block.generatorgalore." + resourceLocation.getPath() + "_generator", LanguageProvider.capName(resourceLocation.getPath()) + " Generator");
            this.add("block.generatorgalore." + resourceLocation.getPath() + "_generator_8x", "8x " + LanguageProvider.capName(resourceLocation.getPath()) + " Generator");
            this.add("block.generatorgalore." + resourceLocation.getPath() + "_generator_64x", "64x " + LanguageProvider.capName(resourceLocation.getPath()) + " Generator");
            if (generatorObject.getUpgradeSupplier() != null) {
                ResourceLocation upgradeItem = BuiltInRegistries.ITEM.getKey((Object)generatorObject.getUpgradeSupplier().get());
                this.add("item.generatorgalore." + upgradeItem.getPath(), LanguageProvider.capName(upgradeItem.getPath()));
            }
        });
    }

    public String getName() {
        return "Generator Galore translation provider";
    }

    public static String capName(String name) {
        CharSequence[] nameParts = name.split("_");
        for (int i = 0; i < nameParts.length; ++i) {
            if (nameParts[i].equals("to")) continue;
            String firstChar = ((String)nameParts[i]).substring(0, 1).toUpperCase();
            nameParts[i] = firstChar + ((String)nameParts[i]).substring(1);
        }
        return String.join((CharSequence)" ", nameParts);
    }
}

