/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.util;

import cy.jdkdigital.generatorgalore.util.collection.SetMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;

public class PotionUtil {
    public static final Map<String, Integer> brewingStepCache = new HashMap<String, Integer>();
    private static final SetMultiMap<String, String> potionMap = new SetMultiMap();

    public static SetMultiMap<String, String> getPotionMap(Level level) {
        if (potionMap.allValues().isEmpty() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List brewingRecipes = serverLevel.potionBrewing().getRecipes();
            brewingRecipes.stream().filter(Objects::nonNull).map(IBrewingRecipe.class::cast).findFirst().ifPresent(vanillaBrewingRecipe -> PotionUtil.addVanillaBrewingRecipes(potionMap, vanillaBrewingRecipe));
            PotionUtil.addModdedBrewingRecipes(brewingRecipes, potionMap);
        }
        return potionMap;
    }

    private static void addVanillaBrewingRecipes(SetMultiMap<String, String> potionMap, IBrewingRecipe vanillaBrewingRecipe) {
        boolean foundNewPotions;
        List<ItemStack> potionIngredients = BuiltInRegistries.ITEM.stream().map(ItemStack::new).filter(arg_0 -> ((PotionBrewing)PotionBrewing.EMPTY).isIngredient(arg_0)).toList();
        List<Item> basePotions = List.of(Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION);
        List knownPotions = BuiltInRegistries.POTION.holders().map(potion -> {
            ArrayList<ItemStack> potions = new ArrayList<ItemStack>();
            if (((Potion)potion.value()).getEffects().size() > 0) {
                for (Item input : basePotions) {
                    ItemStack result = new ItemStack((ItemLike)input);
                    result.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents((Holder)potion));
                    potions.add(result);
                }
            }
            return potions;
        }).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
        do {
            List<ItemStack> newPotions;
            foundNewPotions = !(newPotions = PotionUtil.getNewPotions(knownPotions, potionIngredients, potionMap, vanillaBrewingRecipe)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
    }

    private static List<ItemStack> getNewPotions(Collection<ItemStack> knownPotions, List<ItemStack> potionReagents, SetMultiMap<String, String> potionMap, IBrewingRecipe vanillaBrewingRecipe) {
        ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
        for (ItemStack potionInput : knownPotions) {
            for (ItemStack potionReagent : potionReagents) {
                PotionContents potionInputType;
                PotionContents potionOutputType;
                ItemStack potionOutput = vanillaBrewingRecipe.getOutput(potionInput.copy(), potionReagent);
                if (potionOutput.isEmpty() || potionInput.getItem() == potionOutput.getItem() && (((Holder)(potionOutputType = (PotionContents)potionOutput.get(DataComponents.POTION_CONTENTS)).potion().get()).equals((Object)Potions.WATER) || (potionInputType = (PotionContents)potionInput.get(DataComponents.POTION_CONTENTS)).is((Holder)potionOutputType.potion().get()))) continue;
                potionMap.put(PotionUtil.getUniquePotionName(potionOutput), PotionUtil.getUniquePotionName(potionInput));
            }
        }
        return newPotions;
    }

    private static void addModdedBrewingRecipes(Collection<IBrewingRecipe> brewingRecipes, SetMultiMap<String, String> potionMap) {
        for (IBrewingRecipe iBrewingRecipe : brewingRecipes) {
            ItemStack[] inputs;
            BrewingRecipe brewingRecipe;
            ItemStack[] ingredients;
            if (!(iBrewingRecipe instanceof BrewingRecipe) || (ingredients = (brewingRecipe = (BrewingRecipe)iBrewingRecipe).getIngredient().getItems()).length <= 0) continue;
            Ingredient inputIngredient = brewingRecipe.getInput();
            ItemStack output = brewingRecipe.getOutput();
            for (ItemStack input : inputs = inputIngredient.getItems()) {
                potionMap.put(PotionUtil.getUniquePotionName(output), PotionUtil.getUniquePotionName(input));
            }
        }
    }

    public static String getUniquePotionName(ItemStack stack) {
        PotionContents potionData;
        StringBuilder potionUid = new StringBuilder(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString());
        if (stack.has(DataComponents.POTION_CONTENTS) && (potionData = (PotionContents)stack.get(DataComponents.POTION_CONTENTS)) != null) {
            potionData.getAllEffects().forEach(mobEffectInstance -> potionUid.append(mobEffectInstance.getDescriptionId()));
        }
        return potionUid.toString();
    }
}

