/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.blockentityrenders;

import com.direwolf20.justdirethings.client.blockentityrenders.baseber.AreaAffectingBER;
import com.direwolf20.justdirethings.client.renderers.DireVertexConsumer;
import com.direwolf20.justdirethings.client.renderers.OurRenderTypes;
import com.direwolf20.justdirethings.common.blockentities.ParadoxMachineBE;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public class ParadoxMachineBER
extends AreaAffectingBER {
    public ParadoxMachineBER(BlockEntityRendererProvider.Context context) {
    }

    @Override
    public void render(BlockEntity blockentity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn) {
        super.render(blockentity, partialTicks, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn);
        if (!(blockentity instanceof ParadoxMachineBE)) {
            return;
        }
        ParadoxMachineBE paradoxMachineBE = (ParadoxMachineBE)blockentity;
        if (paradoxMachineBE.isRunning) {
            float alpha = Mth.clamp((float)(0.05f + (float)paradoxMachineBE.timeRunning / (float)paradoxMachineBE.getRunTime() * 0.95f), (float)0.05f, (float)1.0f);
            int intAlpha = (int)(alpha * 255.0f);
            this.renderBlocks(paradoxMachineBE, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, alpha, paradoxMachineBE.restoringBlocks);
            this.renderEntities(paradoxMachineBE, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, intAlpha);
        } else if (paradoxMachineBE.renderParadox) {
            int targetType = paradoxMachineBE.targetType;
            if (targetType == 0 || targetType == 1) {
                this.renderBlocks(paradoxMachineBE, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, 0.5f, paradoxMachineBE.getBlocksFromNBT());
            }
            if (targetType == 0 || targetType == 2) {
                this.renderEntities(paradoxMachineBE, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, 175);
            }
        }
    }

    private void renderBlocks(ParadoxMachineBE paradoxMachineBE, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn, float alpha, Map<BlockPos, BlockState> blocksToRestore) {
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        Level level = paradoxMachineBE.getLevel();
        if (level == null) {
            return;
        }
        BlockColors blockColors = Minecraft.getInstance().getBlockColors();
        ModelBlockRenderer modelBlockRenderer = new ModelBlockRenderer(blockColors);
        BlockRenderDispatcher blockrendererdispatcher = Minecraft.getInstance().getBlockRenderer();
        for (Map.Entry<BlockPos, BlockState> entry : blocksToRestore.entrySet()) {
            BlockPos blockPos = entry.getKey();
            BlockState renderState = entry.getValue();
            if (!level.getBlockState(blockPos).canBeReplaced()) continue;
            float[] afloat = new float[Direction.values().length * 2];
            BitSet bitset = new BitSet(3);
            RandomSource randomSource = RandomSource.create();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = blockPos.mutable();
            BakedModel ibakedmodel = blockrendererdispatcher.getBlockModel(renderState);
            matrixStackIn.pushPose();
            matrixStackIn.translate((float)(blockPos.getX() - paradoxMachineBE.getBlockPos().getX()), (float)(blockPos.getY() - paradoxMachineBE.getBlockPos().getY()), (float)(blockPos.getZ() - paradoxMachineBE.getBlockPos().getZ()));
            VertexConsumer builder = renderState.isSolidRender((BlockGetter)level, blockPos) ? bufferIn.getBuffer(OurRenderTypes.RenderBlockFade) : bufferIn.getBuffer(OurRenderTypes.RenderBlockFadeNoCull);
            DireVertexConsumer direVertexConsumer = new DireVertexConsumer(builder, alpha);
            ModelBlockRenderer.AmbientOcclusionFace modelblockrenderer$ambientocclusionface = new ModelBlockRenderer.AmbientOcclusionFace();
            for (Direction direction : Direction.values()) {
                BlockState otherState;
                randomSource.setSeed(renderState.getSeed(blockPos));
                List list = ibakedmodel.getQuads(renderState, direction, randomSource, ModelData.EMPTY, null);
                if (list.isEmpty()) continue;
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockPos, direction);
                BlockPos testPos = blockPos.relative(direction);
                boolean renderAdjacent = true;
                if (blocksToRestore.containsKey(testPos) && (otherState = blocksToRestore.get(testPos)).isSolidRender((BlockGetter)level, testPos)) {
                    renderAdjacent = false;
                }
                if (!renderAdjacent) continue;
                modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, renderState, blockPos, matrixStackIn, (VertexConsumer)direVertexConsumer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
            }
            randomSource.setSeed(renderState.getSeed(blockPos));
            List list = ibakedmodel.getQuads(renderState, null, randomSource, ModelData.EMPTY, null);
            if (!list.isEmpty()) {
                modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, renderState, blockPos, matrixStackIn, (VertexConsumer)direVertexConsumer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
            }
            matrixStackIn.popPose();
        }
    }

    private void renderEntities(ParadoxMachineBE paradoxMachineBE, PoseStack matrixStackIn, MultiBufferSource bufferIn, float partialTicks, int combinedLightsIn, int alpha) {
        Level level = paradoxMachineBE.getLevel();
        if (level == null) {
            return;
        }
        for (Map.Entry<Vec3, LivingEntity> entry : paradoxMachineBE.getEntitiesFromNBT().entrySet()) {
            Vec3 entityPos = entry.getKey();
            if (paradoxMachineBE.isRunning && !paradoxMachineBE.restoringEntites.contains(entityPos)) continue;
            LivingEntity entity = entry.getValue();
            matrixStackIn.pushPose();
            matrixStackIn.translate(entityPos.x - (double)paradoxMachineBE.getBlockPos().getX(), entityPos.y - (double)paradoxMachineBE.getBlockPos().getY(), entityPos.z - (double)paradoxMachineBE.getBlockPos().getZ());
            this.renderTransparentEntity(matrixStackIn, bufferIn, entity, partialTicks, combinedLightsIn, alpha);
            matrixStackIn.popPose();
        }
    }

    private void renderTransparentEntity(PoseStack matrixStackIn, MultiBufferSource bufferIn, LivingEntity entity, float partialTicks, int combinedLightsIn, int alpha) {
        EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer renderer = renderManager.getRenderer((Entity)entity);
        ResourceLocation resourceLocation = renderer.getTextureLocation((Entity)entity);
        if (resourceLocation == null) {
            return;
        }
        RenderType renderType = RenderType.itemEntityTranslucentCull((ResourceLocation)resourceLocation);
        VertexConsumer vertexconsumer = bufferIn.getBuffer(renderType);
        int overlayCoords = LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f);
        float f = Mth.rotLerp((float)partialTicks, (float)entity.yBodyRot, (float)entity.yBodyRot);
        float f1 = Mth.rotLerp((float)partialTicks, (float)entity.yHeadRot, (float)entity.yHeadRot);
        float f2 = f1 - f;
        float f5 = Mth.lerp((float)partialTicks, (float)entity.getXRot(), (float)entity.getXRot());
        float f7 = 0.0f;
        ParadoxMachineBER.setupRotations(entity, matrixStackIn, f7, f, partialTicks);
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        matrixStackIn.translate(0.0f, -1.501f, 0.0f);
        float f8 = 0.0f;
        float f4 = 0.0f;
        int packedARGB = alpha << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            EntityModel entityModel = livingRenderer.getModel();
            entityModel.attackTime = 0.0f;
            entityModel.riding = false;
            entityModel.young = entity.isBaby();
            entityModel.prepareMobModel((Entity)entity, f4, f8, partialTicks);
            entityModel.setupAnim((Entity)entity, f4, f8, f7, f2, f5);
            entityModel.renderToBuffer(matrixStackIn, vertexconsumer, combinedLightsIn, overlayCoords, packedARGB);
        }
    }

    protected static void setupRotations(LivingEntity pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        if (!pEntityLiving.hasPose(Pose.SLEEPING)) {
            pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f - pRotationYaw));
        }
    }

    protected static void scaleEntity(LivingEntity entity, PoseStack matrixStackIn) {
        float scale = 1.0f;
        matrixStackIn.scale(scale, scale, scale);
    }
}

